/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.ui.navigator;

import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import com.yakindu.sct.ui.navigator.DomainNavigatorItem;
import com.yakindu.sct.ui.navigator.StatechartObjectViewerFilter;
import com.yakindu.sct.ui.navigator.utils.ComposedAdapterFactoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class StatechartNavigatorContentProvider
implements ICommonContentProvider {
    private AdapterFactoryContentProvider myAdapterFactoryContentProvier = new AdapterFactoryContentProvider((AdapterFactory)ComposedAdapterFactoryUtil.FACTORY);
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private TransactionalEditingDomain editingDomain = DiagramPartitioningUtil.getSharedDomain();
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable = new Runnable(){

        @Override
        public void run() {
            if (StatechartNavigatorContentProvider.this.myViewer != null && !StatechartNavigatorContentProvider.this.myViewer.getControl().isDisposed()) {
                StatechartNavigatorContentProvider.this.myViewer.refresh();
            }
        }
    };
    private ViewerFilter viewerFilter;

    public StatechartNavigatorContentProvider() {
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(this.editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                if (StatechartNavigatorContentProvider.this.myViewer != null) {
                    StatechartNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(StatechartNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                if (StatechartNavigatorContentProvider.this.myViewer != null) {
                    StatechartNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(StatechartNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                if (StatechartNavigatorContentProvider.this.myViewer != null) {
                    StatechartNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(StatechartNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.editingDomain.getResourceSet().getResource(fileURI, true);
            return this.wrapEObjects(this.myAdapterFactoryContentProvier.getChildren((Object)resource), parentElement);
        }
        if (parentElement instanceof DomainNavigatorItem) {
            return this.wrapEObjects(this.myAdapterFactoryContentProvier.getChildren((Object)((DomainNavigatorItem)((Object)parentElement)).getEObject()), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] wrapEObjects(Object[] objects, Object parentElement) {
        ArrayList<DomainNavigatorItem> result = new ArrayList<DomainNavigatorItem>();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof EObject) {
                DomainNavigatorItem navigatorItem = new DomainNavigatorItem((EObject)objects[i], parentElement, (IPropertySourceProvider)this.myAdapterFactoryContentProvier);
                if (!(objects[i] instanceof View)) {
                    EObject eObject = (EObject)objects[i];
                    navigatorItem.setView(this.getReferenceView(eObject));
                }
                result.add(navigatorItem);
            }
            ++i;
        }
        return result.toArray();
    }

    private View getReferenceView(EObject eObject) {
        CrossReferenceAdapter refAdapter = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)eObject.eResource());
        if (refAdapter == null) {
            return null;
        }
        Collection inverseReferences = refAdapter.getInverseReferences(eObject, true);
        for (EStructuralFeature.Setting setting : inverseReferences) {
            if (!(setting.getEObject() instanceof View) || setting.getEStructuralFeature() != NotationPackage.eINSTANCE.getView_Element()) continue;
            return (View)setting.getEObject();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return file.getParent();
        }
        if (element instanceof DomainNavigatorItem) {
            DomainNavigatorItem domainNavigatorItem = (DomainNavigatorItem)((Object)element);
            return domainNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.hasVisibleChildren(element);
    }

    protected boolean hasVisibleChildren(Object parent) {
        Object[] children;
        Object[] objectArray = children = this.getChildren(parent);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (this.getViewerFilter().select(null, parent, obj)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected ViewerFilter getViewerFilter() {
        if (this.viewerFilter == null) {
            this.viewerFilter = new StatechartObjectViewerFilter();
        }
        return this.viewerFilter;
    }
}

