/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.generator.java.features;

import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import com.yakindu.sctunit.generator.base.features.SCTUnitFeatureValueProvider;
import com.yakindu.sctunit.generator.java.features.JavaSCTUnitFeatureConstants;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class JavaSCTUnitFeatureValueProvider
extends SCTUnitFeatureValueProvider {
    private static final String PACKAGE_NAME_REGEX = "([a-zA-Z_][a-zA-Z0-9_\\.]*)+[a-zA-Z_][a-zA-Z0-9_]*";
    private static final String TYPE_NAME_REGEX = "[a-zA-Z_$][a-zA-Z0-9_$]*";

    public IStatus validateParameterValue(FeatureParameterValue value) {
        Matcher matcher;
        Pattern pattern;
        IStatus superResult = super.validateParameterValue(value);
        if (superResult != Status.OK_STATUS) {
            return superResult;
        }
        String name = value.getParameter().getName();
        if ("basePackage".equals(name) || "libraryPackage".equals(name)) {
            if (value.getStringValue().isEmpty()) {
                return Status.OK_STATUS;
            }
            if (!value.getStringValue().matches(PACKAGE_NAME_REGEX)) {
                return this.error("Invalid package name");
            }
            for (String keyword : Arrays.asList(JavaSCTUnitFeatureConstants.JAVA_KEYWORDS)) {
                pattern = Pattern.compile("(?:^|\\.)" + keyword + "(?:$|\\.)");
                matcher = pattern.matcher(value.getStringValue());
                if (!matcher.find()) continue;
                return this.error("Java keyword '" + matcher.group() + "' is not allowed in package names.");
            }
        }
        if ("typeName".equals(name)) {
            if (!value.getStringValue().matches(TYPE_NAME_REGEX)) {
                return this.error("Invalid value");
            }
            for (String keyword : Arrays.asList(JavaSCTUnitFeatureConstants.JAVA_KEYWORDS)) {
                pattern = Pattern.compile("^" + keyword + "$");
                matcher = pattern.matcher(value.getStringValue());
                if (!matcher.find()) continue;
                return this.error("Java keyword '" + matcher.group() + "' is not allowed as type name.");
            }
        }
        if ("libraryTargetFolder".equals(name)) {
            String targetProjectName;
            FeatureParameterValue targetProjectParam = value.getFeatureConfiguration().getParameterValue("targetProject");
            String string = targetProjectName = targetProjectParam != null ? targetProjectParam.getStringValue() : null;
            if (targetProjectName != null && !this.access.folderExists(targetProjectName, value.getStringValue())) {
                return this.warning(String.format("The Folder %s does not exist in Project %s", value.getStringValue(), targetProjectName));
            }
        }
        return Status.OK_STATUS;
    }

    public boolean isProviderFor(FeatureTypeLibrary library) {
        return library.getName().equals("SCTUnit Java Generator");
    }

    public void setDefaultValue(FeatureType featureType, FeatureParameterValue parameterValue, EObject contextElement) {
        super.setDefaultValue(featureType, parameterValue, contextElement);
        if (featureType.getName().equals("StatechartNaming")) {
            if (parameterValue.getParameter().getName().equals("basePackage")) {
                parameterValue.setValue("");
            } else if (parameterValue.getParameter().getName().equals("libraryPackage")) {
                parameterValue.setValue("com.yakindu.core");
            } else if (parameterValue.getParameter().getName().equals("libraryTargetFolder")) {
                parameterValue.setValue("src");
            }
        } else if (featureType.getName().equals("Naming") && parameterValue.getParameter().getName().equals("basePackage")) {
            parameterValue.setValue("com.yakindu.sct.tests");
        }
    }
}

