/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.debugmodel;

import com.yakindu.base.base.NamedElement;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SCTDebugElement
extends DebugElement {
    private String resourceString;

    public SCTDebugElement(IDebugTarget target, String resourceString) {
        super(target);
        this.resourceString = resourceString;
    }

    public String getResourceString() {
        return this.resourceString;
    }

    public String getModelIdentifier() {
        return "com.yakindu.sct.debug";
    }

    public String fullQfn(NamedElement element) {
        ArrayList<String> qfnFragments = new ArrayList<String>();
        qfnFragments.add(element.getName());
        NamedElement current = element;
        while (current.eContainer() != EcoreUtil.getRootContainer((EObject)current)) {
            if (!((current = current.eContainer()) instanceof NamedElement)) continue;
            String name = current.getName();
            if (name != null) {
                qfnFragments.add(name.replaceAll(" ", ""));
                continue;
            }
            qfnFragments.add("<name>");
        }
        Collections.reverse(qfnFragments);
        StringBuilder sb = new StringBuilder();
        sb.append(element.getName() != null ? element.getName() : element.eClass().getName());
        sb.append("  (");
        String sep = "";
        for (String s : qfnFragments) {
            sb.append(sep).append(s);
            sep = ".";
        }
        sb.append(")");
        sb.append(" resource: ");
        sb.append(element.eResource().getURI().lastSegment());
        return sb.toString();
    }
}

