/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.refactoring.handlers.impl;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.yakindu.base.base.NamedElement;
import com.yakindu.base.expressions.expressions.ElementReferenceExpression;
import com.yakindu.base.expressions.expressions.FeatureCall;
import com.yakindu.sct.model.sgraph.Scope;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.stext.extensions.STextExtensions;
import com.yakindu.sct.refactoring.handlers.AbstractRefactoringHandler;
import com.yakindu.sct.refactoring.refactor.AbstractRefactoring;
import com.yakindu.sct.refactoring.refactor.impl.RenameRefactoring;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class RenameElementHandler
extends AbstractRefactoringHandler<NamedElement> {
    @Inject
    private IResourceValidator validator;
    @Inject
    protected STextExtensions utils;

    public RenameElementHandler() {
        Guice.createInjector((Module[])new Module[0]).injectMembers((Object)this);
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        NamedElement element = (NamedElement)this.refactoring.getContextObject();
        if (element != null) {
            String newName;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            List issues = this.validator.validate(element.eResource(), CheckMode.NORMAL_AND_FAST, CancelIndicator.NullImpl);
            Stream<Issue> errors = issues.stream().filter(issue -> issue.getSeverity() == Severity.ERROR);
            RenameDialog dialog = new RenameDialog(window.getShell(), "Rename..", "Please enter new name: ", element.getName(), new NameUniquenessValidator(element), errors.count() > 0L);
            if (dialog.open() == 0 && (newName = dialog.getNewName()) != null) {
                ((RenameRefactoring)this.refactoring).setNewName(newName);
                this.refactoring.execute();
            }
        }
        return null;
    }

    public NamedElement unwrap(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (!(structuredSelection.getFirstElement() instanceof EObject)) {
            return null;
        }
        EObject selectedElement = (EObject)structuredSelection.getFirstElement();
        if (selectedElement instanceof FeatureCall) {
            return this.findInStatechart((NamedElement)((FeatureCall)selectedElement).getFeature());
        }
        if (selectedElement instanceof ElementReferenceExpression) {
            return this.findInStatechart((NamedElement)((ElementReferenceExpression)selectedElement).getReference());
        }
        if (selectedElement instanceof NamedElement) {
            return this.findInStatechart((NamedElement)selectedElement);
        }
        return null;
    }

    private NamedElement findInStatechart(NamedElement fakeElement) {
        Statechart sct;
        EObject elem;
        Resource resource = fakeElement.eResource();
        if (resource instanceof LazyLinkingResource && (elem = this.utils.findElement((EObject)fakeElement, sct = this.utils.getStatechart((Resource)((LazyLinkingResource)resource)))) instanceof NamedElement) {
            return (NamedElement)elem;
        }
        return fakeElement;
    }

    @Override
    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPartSite site = window.getActivePage().getActiveEditor().getSite();
        if (site == null) {
            return false;
        }
        ISelectionProvider selectionProvider = site.getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection currentSelection = selectionProvider.getSelection();
        this.setContext(this.refactoring, currentSelection);
        return this.refactoring.isExecutable();
    }

    @Override
    public AbstractRefactoring<NamedElement> createRefactoring() {
        return new RenameRefactoring();
    }

    @Override
    public void setContext(AbstractRefactoring<NamedElement> refactoring, ISelection selection) {
        NamedElement element = this.unwrap(selection);
        if (element != null) {
            refactoring.setContextObjects(Lists.newArrayList((Object[])new NamedElement[]{element}));
        }
    }

    private class NameUniquenessValidator
    implements IInputValidator {
        protected List<String> existingNames = Lists.newArrayList();

        public NameUniquenessValidator(NamedElement element) {
            Scope scope = (Scope)EcoreUtil2.getContainerOfType((EObject)element, Scope.class);
            List allOfSameType = EcoreUtil2.getAllContentsOfType((EObject)scope, NamedElement.class);
            allOfSameType.remove(element);
            for (NamedElement namedElement : allOfSameType) {
                this.existingNames.add(namedElement.getName());
            }
        }

        public String isValid(String newText) {
            return this.existingNames.contains(newText) ? "Name '" + newText + "' already exists." : null;
        }
    }

    protected static class RenameDialog
    extends Dialog {
        private boolean modelContainsErrors;
        private Label messageLabel;
        private Label iconLabel;
        private IInputValidator validator;
        private Text text;
        private String dialogTitle;
        private String dialogMessage;
        private String newName = "";
        private String initialValue = "";

        public RenameDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, boolean hasDefinitionSectionErrors) {
            super(parentShell);
            this.dialogTitle = dialogTitle;
            this.dialogMessage = dialogMessage;
            this.initialValue = initialValue;
            this.validator = validator;
            this.modelContainsErrors = hasDefinitionSectionErrors;
        }

        protected Control createDialogArea(Composite parent) {
            parent.getShell().setText(this.dialogTitle);
            GridDataFactory.fillDefaults().applyTo((Control)parent);
            GridLayoutFactory.fillDefaults().margins(10, 4).spacing(0, 5).applyTo(parent);
            this.createStatusComposite(parent);
            this.createTextComosite(parent);
            return parent;
        }

        private void createStatusComposite(Composite parent) {
            Composite statusComposite = new Composite(parent, 0);
            this.iconLabel = new Label(statusComposite, 0);
            this.messageLabel = new Label(statusComposite, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(statusComposite);
            GridDataFactory.fillDefaults().grab(true, false).hint(450, -1).applyTo((Control)statusComposite);
            GridDataFactory.fillDefaults().grab(false, false).hint(15, 15).applyTo((Control)this.iconLabel);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.messageLabel);
        }

        public void createTextComosite(Composite parent) {
            Label lblTxt = new Label(parent, 64);
            lblTxt.setText(this.dialogMessage);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)lblTxt);
            this.text = new Text(parent, 2048);
            this.text.setText(this.initialValue);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.text);
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.validate();
                }
            });
            this.validate();
        }

        protected void okPressed() {
            this.newName = this.text.getText();
            super.okPressed();
        }

        protected void validate() {
            this.setErrorMessage(this.validator.isValid(this.text.getText()));
        }

        public void setErrorMessage(String errorMessage) {
            this.messageLabel.setText("");
            this.iconLabel.setImage(null);
            if (errorMessage == null) {
                this.activateOKButton();
            } else {
                this.deactivateOKButton(errorMessage);
            }
            this.getShell().layout();
        }

        protected void deactivateOKButton(String errorMessage) {
            this.enableOkButton(false);
            this.messageLabel.setText(errorMessage);
            this.iconLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            this.messageLabel.setVisible(true);
            this.iconLabel.setVisible(true);
        }

        protected void activateOKButton() {
            this.enableOkButton(true);
            if (this.modelContainsErrors) {
                this.messageLabel.setText("The model contains errors. The refactoring may not complete successfully.");
                this.iconLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
                this.messageLabel.setVisible(true);
                this.iconLabel.setVisible(true);
            }
        }

        protected void enableOkButton(boolean enable) {
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(enable);
            }
        }

        public String getNewName() {
            return this.newName;
        }
    }
}

