/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.xtext.utils.gmf.figures;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.text.FlowUtilitiesEx;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextFlowEx;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextUtilitiesEx;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SyntaxColoringLabel
extends WrappingLabel
implements MouseMotionListener {
    private static final MarginBorder NO_FOCUS_BORDER = new MarginBorder(new Insets(1, 1, 1, 1));
    private static final LineBorder FOCUS_BORDER = new LineBorder(ColorConstants.lightGray);
    private StyledTextFlow textFlow;

    public SyntaxColoringLabel() {
        this.setBorder((Border)NO_FOCUS_BORDER);
        this.addMouseMotionListener(this);
        this.setTextFlow();
    }

    protected void setTextFlow() {
        this.textFlow = new StyledTextFlow();
        this.textFlow.setParent(this.getTextFigure());
        List children = this.getTextFigure().getChildren();
        children.set(0, this.textFlow);
        this.setLayoutManager((TextFlow)this.textFlow, false);
    }

    public void setZoom(double zoom) {
        this.textFlow.zoom = zoom;
    }

    public void setHighlight(boolean highlight) {
        this.textFlow.setHighlight(highlight);
    }

    public boolean isHighlight() {
        return this.textFlow.isHighlight();
    }

    public void setRanges(StyleRange[] ranges) {
        this.textFlow.clearCache();
        this.textFlow.setRanges(ranges);
    }

    public void setText(String text) {
        if (this.textFlow != null) {
            this.textFlow.clearCache();
        }
        super.setText(text);
    }

    public void mouseEntered(MouseEvent me) {
        this.setBorder((Border)FOCUS_BORDER);
    }

    public void mouseExited(MouseEvent me) {
        this.setBorder((Border)NO_FOCUS_BORDER);
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    protected static class StyledTextFlow
    extends TextFlowEx {
        private FlowUtilitiesEx flowUtilities;
        private StyleTextUtilities textUtilities;
        private static final Image dummy = new Image((Device)Display.getDefault(), 1, 1);
        private static final GC gc = new GC((Drawable)dummy);
        private Font boldFont;
        private double zoom = 1.0;
        private boolean highlight = false;
        private int fromIndex = 0;
        private StyleRange[] ranges = new StyleRange[0];

        protected StyledTextFlow() {
        }

        public void setHighlight(boolean highlight) {
            this.highlight = highlight;
        }

        public boolean isHighlight() {
            return this.highlight;
        }

        public StyleRange[] getRanges() {
            return this.ranges;
        }

        public void setRanges(StyleRange[] ranges) {
            this.ranges = ranges;
        }

        protected void layout() {
            super.layout();
        }

        public void setFont(Font f) {
            super.setFont(f);
            this.setBoldFont(f);
        }

        protected void setBoldFont(Font f) {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)this.getFont()).setStyle(1);
            this.boldFont = boldDescriptor.createFont((Device)Display.getDefault());
        }

        protected void paintFigure(Graphics g) {
            this.fromIndex = 0;
            super.paintFigure(g);
        }

        protected void paintText(Graphics g, String draw, int x, int y, int bidiLevel) {
            if (!this.highlight) {
                super.paintText(g, draw, x, y, bidiLevel);
                return;
            }
            if (this.ranges.length == 0) {
                draw = this.replaceTabs(draw);
                super.paintText(g, draw, x, y, bidiLevel);
                return;
            }
            if (bidiLevel == -1) {
                String originalDraw = draw;
                int paintOffset = 0;
                int lineOffset = this.getText().indexOf(originalDraw, Math.min(this.fromIndex, this.getText().length() - 1));
                this.fromIndex += originalDraw.length();
                if (lineOffset == -1) {
                    originalDraw = this.replaceTabs(originalDraw);
                    super.paintText(g, originalDraw, x, y, bidiLevel);
                    return;
                }
                try {
                    g.pushState();
                    g.setFont(this.getFont());
                    StyleRange[] styleRangeArray = this.ranges;
                    int n = this.ranges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Font font;
                        StyleRange range = styleRangeArray[n2];
                        int beginIndex = range.start - lineOffset;
                        if (beginIndex > draw.length()) {
                        }
                        Font font2 = font = 1 == (range.fontStyle & 1) ? this.boldFont : this.getFont();
                        if (font != g.getFont()) {
                            g.setFont(font);
                        }
                        g.setForegroundColor(range.foreground != null ? range.foreground : this.getForegroundColor());
                        g.setBackgroundColor(range.background != null ? range.background : this.getBackgroundColor());
                        int endIndex = beginIndex + range.length;
                        String substring = draw.substring(beginIndex > 0 ? beginIndex : 0, Math.min(endIndex > 0 ? endIndex : 0, draw.length()));
                        substring = this.replaceTabs(substring);
                        g.drawText(substring, x + paintOffset, y);
                        int offset = this.getTextExtend(g.getFont(), substring);
                        paintOffset += offset;
                        ++n2;
                    }
                }
                finally {
                    g.popState();
                }
            } else {
                super.paintText(g, draw, x, y, bidiLevel);
            }
        }

        protected String replaceTabs(String draw) {
            return draw.replaceAll("\t", "    ");
        }

        protected int getTextExtend(Font font, String string) {
            if (string.isEmpty()) {
                return 0;
            }
            if (this.zoom != 1.0) {
                FontData data = font.getFontData()[0];
                FontDescriptor newFontDescriptor = FontDescriptor.createFrom((Font)font).setHeight((int)((double)data.getHeight() * this.zoom));
                font = newFontDescriptor.createFont((Device)Display.getDefault());
            }
            if (gc.getFont() != font) {
                gc.setFont(font);
            }
            int offset = StyledTextFlow.gc.textExtent((String)string).x;
            if (this.zoom != 1.0) {
                font.dispose();
            }
            return (int)Math.ceil((double)offset / this.zoom);
        }

        public FlowUtilitiesEx getFlowUtilities() {
            if (this.flowUtilities == null) {
                this.flowUtilities = new FlowUtilitiesEx(MapModeUtil.getMapMode((IFigure)this)){

                    protected TextUtilities getTextUtilities() {
                        if (textUtilities == null) {
                            textUtilities = new StyleTextUtilities(MapModeUtil.getMapMode((IFigure)this));
                        }
                        return textUtilities;
                    }
                };
            }
            return this.flowUtilities;
        }

        public void clearCache() {
            if (this.textUtilities != null) {
                this.textUtilities.invalidate();
            }
        }

        protected class StyleTextUtilities
        extends TextUtilitiesEx {
            protected LoadingCache<String, Dimension> cache;

            public StyleTextUtilities(IMapMode mapmode) {
                super(mapmode);
                this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Dimension>(){

                    public Dimension load(String key) throws Exception {
                        return StyleTextUtilities.this.getTextExtentsInternal(key, StyledTextFlow.this.getFont());
                    }
                });
            }

            public Dimension getTextExtents(String draw, Font f) {
                try {
                    return (Dimension)this.cache.get((Object)draw);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    return super.getTextExtents(draw, f);
                }
            }

            protected Dimension getTextExtentsInternal(String draw, Font f) {
                draw = StyledTextFlow.this.replaceTabs(draw);
                Dimension d = super.getTextExtents(draw, f).getCopy();
                int paintOffset = 0;
                int lineOffset = StyledTextFlow.this.getText().indexOf(draw);
                StyleRange[] styleRangeArray = StyledTextFlow.this.ranges;
                int n = StyledTextFlow.this.ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    StyleRange range = styleRangeArray[n2];
                    int beginIndex = range.start - lineOffset;
                    if (beginIndex > draw.length()) break;
                    int endIndex = beginIndex + range.length;
                    String substring = draw.substring(beginIndex > 0 ? beginIndex : 0, Math.min(endIndex > 0 ? endIndex : 0, draw.length()));
                    Font font = 1 == (range.fontStyle & 1) ? StyledTextFlow.this.boldFont : StyledTextFlow.this.getFont();
                    int offset = StyledTextFlow.this.getTextExtend(font, substring);
                    paintOffset += offset;
                    ++n2;
                }
                d.width = Math.max(d.width, paintOffset);
                return d;
            }

            public void invalidate() {
                this.cache.invalidateAll();
            }
        }
    }
}

