/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.drop;

import com.yakindu.sct.examples.wizard.ExampleWizard;
import com.yakindu.sct.examples.wizard.drop.ExampleURLHandler;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExampleDropTargetListener
extends DropTargetAdapter {
    private static final int[] PREFERRED_DROP_OPERATIONS = new int[]{16, 1, 2, 4};

    public void dragEnter(DropTargetEvent e) {
        this.updateDragDetails(e);
    }

    public void dragOver(DropTargetEvent e) {
        this.updateDragDetails(e);
    }

    public void dragLeave(DropTargetEvent e) {
        if (e.detail == 0) {
            this.setDropOperation(e);
        }
    }

    public void dropAccept(DropTargetEvent e) {
        this.updateDragDetails(e);
    }

    public void dragOperationChanged(DropTargetEvent e) {
        this.updateDragDetails(e);
    }

    private void setDropOperation(DropTargetEvent e) {
        int allowedOperations = e.operations;
        int[] nArray = PREFERRED_DROP_OPERATIONS;
        int n = PREFERRED_DROP_OPERATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            int op = nArray[n2];
            if ((allowedOperations & op) != 0) {
                e.detail = op;
                return;
            }
            ++n2;
        }
        e.detail = allowedOperations;
    }

    private void updateDragDetails(DropTargetEvent e) {
        if (this.dropTargetIsValid(e, false)) {
            this.setDropOperation(e);
        }
    }

    private boolean dropTargetIsValid(DropTargetEvent e, boolean isDrop) {
        if (URLTransfer.getInstance().isSupportedType(e.currentDataType)) {
            if (isDrop || Util.isWindows()) {
                if (e.data == null && !this.extractEventData(e)) {
                    return !isDrop;
                }
                String url = this.getUrl(e.data);
                if (!ExampleURLHandler.isValidExample(url)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean extractEventData(DropTargetEvent e) {
        Object data;
        TransferData transferData = e.currentDataType;
        if (transferData != null && (data = URLTransfer.getInstance().nativeToJava(transferData)) != null && this.getUrl(data) != null) {
            e.data = data;
            return true;
        }
        return false;
    }

    public void drop(DropTargetEvent event) {
        if (!URLTransfer.getInstance().isSupportedType(event.currentDataType)) {
            return;
        }
        final String url = this.getUrl(event.data);
        if (ExampleURLHandler.isValidExample(url)) {
            DropTarget source = (DropTarget)event.getSource();
            Display display = source.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExampleDropTargetListener.this.proceedInstallation(url);
                }
            });
        }
    }

    protected void proceedInstallation(String url) {
        this.createWizardDialog(ExampleURLHandler.extractExampleId(url));
    }

    private void createWizardDialog(String exampleId) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ExampleWizard exampleWizard = new ExampleWizard(exampleId);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)exampleWizard);
        dialog.open();
    }

    private String getUrl(Object eventData) {
        if (eventData == null) {
            return null;
        }
        if (eventData == null || !(eventData instanceof String)) {
            return null;
        }
        String[] dataLines = ((String)eventData).split(System.getProperty("line.separator"));
        String url = dataLines[0];
        return url;
    }
}

