/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal;

import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.ServerSettings;
import com.yakindu.licmgmt.internal.ILicenseSettings;
import com.yakindu.licmgmt.internal.LicenseService;
import com.yakindu.licmgmt.internal.LoggingHelper;
import com.yakindu.licmgmt.internal.events.LicenseServerSettingsEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class LicenseSettings
implements ILicenseSettings {
    private static final String LMX_LICENSE_PATH = "LMX_LICENSE_PATH";
    private Properties properties;
    private ServerSettings serverSettings;

    protected LicenseSettings() {
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        return this.properties;
    }

    protected Properties loadProperties() {
        Properties properties = new Properties();
        File propertyFile = this.getPropertyFile();
        if (propertyFile.exists()) {
            LoggingHelper.debug("Trying to load properties file %s.", propertyFile.getPath());
            try {
                this.readProperties(properties, propertyFile);
            }
            catch (IOException e) {
                LoggingHelper.error("%s thrown when loading properties: %s", e.getClass().getName(), e.getMessage());
                return new Properties();
            }
            catch (IllegalArgumentException e) {
                LoggingHelper.error("%s thrown when loading properties: %s", e.getClass().getName(), e.getMessage());
                return new Properties();
            }
        } else {
            LoggingHelper.debug("Property file does not exist: %s", propertyFile.getAbsolutePath());
        }
        return properties;
    }

    protected void readProperties(Properties properties, File propertyFile) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileReader reader = new FileReader(propertyFile);){
            properties.load(reader);
            LoggingHelper.debug("Properties loaded from file: %s", propertyFile.getAbsolutePath());
            if (!properties.isEmpty()) {
                LoggingHelper.debug("Found the following property sets in file '%s': %s", propertyFile.getAbsolutePath(), properties.toString());
            } else {
                LoggingHelper.debug("The properties file '%s' does not seem to contain any valid entries.", propertyFile.getAbsolutePath(), properties.toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected File getPropertyFile() {
        String defaultPath = ".";
        String configPath = this.getSystemProperty("ylm.config.path");
        String path = configPath != null && !configPath.isEmpty() ? configPath : ".";
        return new File(path, "ylm.properties");
    }

    protected String readPropertyValue(ILicenseSettings.YLM_PROPERTY property) {
        String key = property.getKey();
        try {
            String envValue = this.getEnvironmentProperty(key);
            if (envValue != null) {
                return envValue;
            }
        }
        catch (SecurityException e) {
            LoggingHelper.warn("Searching for property '%s' in environment variables failed with a %s: %s", key, e.getClass().getName(), e.getMessage());
        }
        try {
            String systemValue = this.getSystemProperty(key);
            if (systemValue != null) {
                return systemValue;
            }
        }
        catch (SecurityException e) {
            LoggingHelper.warn("Searching for property '%s' in System properties failed with a %s: %s", key, e.getClass().getName(), e.getMessage());
        }
        String propertiesValue = this.getFileProperty(key);
        if (propertiesValue != null) {
            return propertiesValue;
        }
        return null;
    }

    protected String getEnvironmentProperty(String key) {
        return System.getenv(key);
    }

    protected String getFileProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    protected String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    protected String getPropertyValue(ILicenseSettings.YLM_PROPERTY property) {
        String propertyValue = this.readPropertyValue(property);
        if (propertyValue == null || propertyValue.isEmpty()) {
            return property.getDefaultValue();
        }
        return propertyValue;
    }

    @Override
    public boolean isAutoBorrowingEnabled() {
        String autoBorrowing = this.getPropertyValue(ILicenseSettings.YLM_PROPERTY.ENABLE_AUTO_BORROWING);
        return "1".equals(autoBorrowing);
    }

    @Override
    public boolean isTrialEnabled() {
        String disableTrial = this.getPropertyValue(ILicenseSettings.YLM_PROPERTY.DISABLE_TRIAL);
        return !"1".equals(disableTrial);
    }

    @Override
    public boolean isCheckClientHostIds() {
        String checkClientHostIds = this.getPropertyValue(ILicenseSettings.YLM_PROPERTY.CHECK_CLIENT_HOSTIDS);
        return "1".equals(checkClientHostIds);
    }

    private ServerSettings loadExternalServerSettings() {
        ServerSettings server;
        ServerSettings server2;
        String lmxLicensePath = this.getEnvironmentProperty(LMX_LICENSE_PATH);
        if (lmxLicensePath != null && !lmxLicensePath.isEmpty() && (server2 = ServerSettings.createFrom(lmxLicensePath, true)) != ServerSettings.NOT_AVAILABLE) {
            return server2;
        }
        String serverPath = this.getPropertyValue(ILicenseSettings.YLM_PROPERTY.SERVER_PATH);
        if (serverPath != null && !serverPath.isEmpty() && (server = ServerSettings.createFrom(serverPath, true)) != ServerSettings.NOT_AVAILABLE) {
            return server;
        }
        return ServerSettings.NOT_AVAILABLE;
    }

    @Override
    public ServerSettings getServerSettings() {
        if (this.serverSettings == null) {
            this.serverSettings = this.loadExternalServerSettings();
        }
        return this.serverSettings;
    }

    public void setServerSettings(ServerSettings newServerSettings) {
        if (newServerSettings == null) {
            throw new IllegalArgumentException("argument must not be null.");
        }
        if (this.serverSettings != null && this.serverSettings.isExternal()) {
            throw new IllegalArgumentException("Server settings are unmodifieable because external server settings are set: " + this.serverSettings);
        }
        if (newServerSettings.getHost() == null || newServerSettings.getHost().isEmpty()) {
            newServerSettings = ServerSettings.NOT_AVAILABLE;
        }
        if (!newServerSettings.equals(this.serverSettings)) {
            this.serverSettings = newServerSettings;
            ((LicenseService)ILicenseService.INSTANCE).postEvent(LicenseServerSettingsEvent.create(this.serverSettings));
        }
    }

    public void clear() {
        this.serverSettings = null;
    }

    @Override
    public int getDaysToNotifySoonExpiringLicenses() {
        String days = this.getPropertyValue(ILicenseSettings.YLM_PROPERTY.DAYS_TO_NOTIFY_EXPIRING_LICENSES);
        if (days != null && days.matches("\\d+")) {
            return Integer.parseInt(days);
        }
        return 10;
    }

    @Override
    public String getCustomHostId() {
        return this.getPropertyValue(ILicenseSettings.YLM_PROPERTY.CUSTOM_HOSTID);
    }
}

