/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal;

import com.xformation.lmx.Lmx;
import com.xformation.lmx.LmxException;
import com.xformation.lmx.LmxHostid;
import com.xformation.lmx.LmxHostidType;
import com.xformation.lmx.LmxStatus;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.internal.LicenseService;
import com.yakindu.licmgmt.internal.LoggingHelper;
import com.yakindu.licmgmt.internal.events.LicenseEvent;
import com.yakindu.licmgmt.internal.events.LicenseWarningEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class LicenseTaskFactory {
    private static long HEARTBEAT_PERIOD_MS = TimeUnit.SECONDS.toMillis(90L);
    private static long TIMER_INITIAL_DELAY_MS = TimeUnit.SECONDS.toMillis(30L);
    public static final int TIMER_FAILURE_COUNT = 3;
    private static long DONGLE_PERIOD_MS = HEARTBEAT_PERIOD_MS;
    private static final long EXPIRATION_PERIOD_MS = HEARTBEAT_PERIOD_MS;

    public Timer createHeartbeatTask(Lmx lmx, String featureId, Consumer<LmxException> heartbeatFailed) {
        return this.scheduleTask(new HeartbeatTask(lmx, featureId, heartbeatFailed), TIMER_INITIAL_DELAY_MS, HEARTBEAT_PERIOD_MS);
    }

    public Timer createDongleTask(Lmx lmx, String dongleId, String featureId, Consumer<LmxException> dongleFailed) {
        return this.scheduleTask(new DongleTask(lmx, dongleId, featureId, dongleFailed), TIMER_INITIAL_DELAY_MS, DONGLE_PERIOD_MS);
    }

    public Timer createExpirationTask(Lmx lmx, String featureId, long delay, Consumer<LmxException> expired) {
        return this.scheduleTask(new ExpirationTask(lmx, featureId, expired), delay, EXPIRATION_PERIOD_MS);
    }

    protected Timer scheduleTask(TimerTask task, long delay, long period) {
        Timer timer = new Timer();
        timer.schedule(task, delay, period);
        return timer;
    }

    private static abstract class AbstractLicenseTask
    extends TimerTask {
        protected final Lmx lmx;
        protected final Consumer<LmxException> failed;

        private AbstractLicenseTask(Lmx lmx, Consumer<LmxException> failed) {
            this.lmx = lmx;
            this.failed = failed;
        }
    }

    protected static class DongleTask
    extends AbstractLicenseTask {
        private final String dongleId;
        private final String featureId;
        private int failures = 0;

        public DongleTask(Lmx lmx, String dongleId, String featureId, Consumer<LmxException> failed) {
            super(lmx, failed);
            this.dongleId = dongleId;
            this.featureId = featureId;
        }

        @Override
        public void run() {
            try {
                LmxHostid[] lmxHostidArray = this.lmx.getHostid(LmxHostidType.LMX_HOSTID_DONGLE_HASPHL);
                int n = lmxHostidArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LmxHostid lmxHostid = lmxHostidArray[n2];
                    if (this.dongleId.equals(lmxHostid.getValue())) {
                        this.resetFailures();
                        return;
                    }
                    ++n2;
                }
                this.dongleMissing(new LmxException(LmxStatus.LMX_DONGLE_ERROR, 0L));
            }
            catch (LmxException e) {
                if (e.getErrorCode() == LmxStatus.LMX_DONGLE_ERROR) {
                    this.dongleMissing(e);
                }
                LoggingHelper.error("Some unexpected %s occurred while checking dongle with ID '%s'", e, ((Object)((Object)e)).getClass().getSimpleName(), this.dongleId);
            }
        }

        protected void resetFailures() {
            this.failures = 0;
        }

        private void dongleMissing(LmxException exception) {
            if (++this.failures >= 3) {
                this.failed.accept(exception);
            } else {
                long intervalInSec = TimeUnit.MILLISECONDS.toSeconds(DONGLE_PERIOD_MS);
                LicenseEvent event = LicenseWarningEvent.createForSingleDongleFailure(exception, this.featureId, intervalInSec);
                ((LicenseService)ILicenseService.INSTANCE).postEvent(event);
            }
        }
    }

    protected static class ExpirationTask
    extends AbstractLicenseTask {
        private final String featureId;

        public ExpirationTask(Lmx lmx, String featureId, Consumer<LmxException> expired) {
            super(lmx, expired);
            this.featureId = featureId;
        }

        @Override
        public void run() {
            if (this.lmx.getExpireTime(this.featureId) == -1) {
                this.failed.accept(new LmxException(LmxStatus.LMX_TOO_LATE_DATE, 0L));
            }
        }
    }

    protected static class HeartbeatTask
    extends AbstractLicenseTask {
        private final String featureId;
        private int failures = 0;

        public HeartbeatTask(Lmx lmx, String featureId, Consumer<LmxException> failed) {
            super(lmx, failed);
            this.featureId = featureId;
        }

        @Override
        public void run() {
            try {
                LoggingHelper.trace("Sending heartbeat to LM-X license server.", new Object[0]);
                this.lmx.heartbeat(this.featureId);
                this.resetFailures();
            }
            catch (LmxException e) {
                if (++this.failures >= 3) {
                    this.failed.accept(e);
                }
                long intervalInSec = TimeUnit.MILLISECONDS.toSeconds(HEARTBEAT_PERIOD_MS);
                LicenseEvent event = LicenseWarningEvent.createForSingleHeartbeatFailure(e, intervalInSec);
                ((LicenseService)ILicenseService.INSTANCE).postEvent(event);
            }
        }

        protected void resetFailures() {
            this.failures = 0;
        }
    }
}

