/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.model.presenter;

import com.google.common.collect.Lists;
import com.yakindu.base.gmf.runtime.highlighting.HighlightingParameters;
import com.yakindu.base.gmf.runtime.highlighting.IHighlightingSupport;
import com.yakindu.sct.model.sgraph.RegularState;
import com.yakindu.sct.model.sruntime.CrossDocumentContentAdapter;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.model.sruntime.SRuntimePackage;
import com.yakindu.sct.simulation.ui.model.presenter.DefaultDynamicNotationHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;

public class ExecutionContextVisualizer
extends CrossDocumentContentAdapter {
    private IHighlightingSupport highlightingSupport;

    public ExecutionContextVisualizer(IHighlightingSupport support) {
        this.highlightingSupport = support;
    }

    protected boolean shouldAdapt(EStructuralFeature feature) {
        return feature == SRuntimePackage.Literals.EXECUTION_CONTEXT__ACTIVE_STATES || feature == SRuntimePackage.Literals.EXECUTION_CONTEXT__EXECUTED_ELEMENTS || feature == SRuntimePackage.Literals.EXECUTION_CONTEXT__SUSPENDED_ELEMENTS;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getFeature() == SRuntimePackage.Literals.EXECUTION_CONTEXT__ACTIVE_STATES) {
            this.highlightActiveStates(notification, DefaultDynamicNotationHandler.STATE_HIGHLIGHT_PARAMS);
        } else if (notification.getFeature() == SRuntimePackage.Literals.EXECUTION_CONTEXT__EXECUTED_ELEMENTS) {
            this.highlight(notification, DefaultDynamicNotationHandler.TRANSITION_PARAMS);
        } else if (notification.getFeature() == SRuntimePackage.Literals.EXECUTION_CONTEXT__SUSPENDED_ELEMENTS) {
            this.highlightSuspendedElements(notification);
        }
    }

    protected void highlightSuspendedElements(Notification notification) {
        this.highlight(notification, DefaultDynamicNotationHandler.SUSPENDED_PARAMS);
        ArrayList<IHighlightingSupport.Highlight> actions = new ArrayList<IHighlightingSupport.Highlight>();
        ExecutionContext context = this.getExecutionContext(notification);
        List<EObject> newValues = this.toList(notification.getNewValue());
        List<EObject> oldValues = this.toList(notification.getOldValue());
        oldValues.removeAll(newValues);
        for (EObject eObject : oldValues) {
            if (!context.getActiveStates().contains(eObject)) continue;
            actions.add(new IHighlightingSupport.Highlight(eObject, DefaultDynamicNotationHandler.STATE_HIGHLIGHT_PARAMS));
        }
        this.getHighlightingSupport().executeAsync(actions);
    }

    private ExecutionContext getExecutionContext(Notification notification) {
        return (ExecutionContext)EcoreUtil2.getContainerOfType((EObject)((EObject)notification.getNotifier()), ExecutionContext.class);
    }

    protected void highlightActiveStates(Notification notification, HighlightingParameters params) {
        int eventType = notification.getEventType();
        List<EObject> objects = null;
        if (eventType == 3 || eventType == 5) {
            objects = this.toList(notification.getNewValue());
        } else if (eventType == 4 || eventType == 6) {
            objects = this.toList(notification.getOldValue());
        }
        if (objects.size() == 0) {
            return;
        }
        ArrayList<IHighlightingSupport.Highlight> actions = new ArrayList<IHighlightingSupport.Highlight>();
        for (EObject eObject : objects) {
            if (!(eObject instanceof RegularState)) continue;
            EObject container = eObject;
            while (container != null) {
                if (container instanceof RegularState) {
                    if (eventType == 3 || eventType == 5) {
                        actions.add(new IHighlightingSupport.Highlight(container, params));
                    } else if (eventType == 4 || eventType == 6) {
                        actions.add(new IHighlightingSupport.Highlight(container, null));
                    }
                }
                container = container.eContainer();
            }
        }
        this.getHighlightingSupport().executeAsync(actions);
    }

    protected void highlight(Notification notification, HighlightingParameters params) {
        ArrayList<IHighlightingSupport.Highlight> actions = new ArrayList<IHighlightingSupport.Highlight>();
        int eventType = notification.getEventType();
        if (eventType == 3 || eventType == 5) {
            List<EObject> objects = this.toList(notification.getNewValue());
            actions.add(new IHighlightingSupport.Highlight(objects, params));
        } else if (eventType == 4 || eventType == 6) {
            List<EObject> objects = this.toList(notification.getOldValue());
            actions.add(new IHighlightingSupport.Highlight(objects, null));
        }
        this.getHighlightingSupport().executeAsync(actions);
    }

    private List<EObject> toList(Object value) {
        ArrayList objects = Lists.newArrayList();
        if (value instanceof EObject) {
            objects.add((EObject)value);
        } else if (value instanceof List) {
            objects.addAll((List)value);
        }
        return objects;
    }

    public IHighlightingSupport getHighlightingSupport() {
        return this.highlightingSupport;
    }

    public void setHighlightingSupport(IHighlightingSupport highlightingSupport) {
        this.highlightingSupport = highlightingSupport;
    }
}

