/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.ui.view;

import com.google.common.collect.Lists;
import com.yakindu.base.expressions.interpreter.base.IInterpreter;
import com.yakindu.base.expressions.interpreter.base.InterpreterAdapter;
import com.yakindu.base.expressions.interpreter.base.InterpreterSession;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.domain.extension.DomainRegistry;
import com.yakindu.sct.domain.extension.IDomain;
import com.yakindu.sct.model.sgraph.Statechart;
import com.yakindu.sct.model.sruntime.ExecutionEvent;
import com.yakindu.sct.model.sruntime.ReferenceExecutionEvent;
import com.yakindu.sct.simulation.core.debugmodel.SCTDebugTarget;
import com.yakindu.sct.simulation.core.engine.ISimulationEngine;
import com.yakindu.sct.simulation.ui.actions.TerminateAndRelaunchAction;
import com.yakindu.sct.simulation.ui.view.AbstractDebugTargetView;
import com.yakindu.sct.simulation.ui.view.Clock;
import com.yakindu.sct.simulation.ui.view.ExecutionContextContentProvider;
import com.yakindu.sct.simulation.ui.view.ExecutionContextViewerFactory;
import com.yakindu.sct.simulation.ui.view.SimulationSessionViewerFactory;
import com.yakindu.sct.simulation.ui.view.actions.CollapseAllAction;
import com.yakindu.sct.simulation.ui.view.actions.ExpandAllAction;
import com.yakindu.sct.simulation.ui.view.actions.HideTimeEventsAction;
import com.yakindu.sct.simulation.ui.view.editing.ScopeSlotEditingSupport;
import com.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import java.util.ArrayList;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.internal.ui.commands.actions.RestartCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.ResumeCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepOverCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.SuspendCommandAction;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.DebugCommandAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SimulationView
extends AbstractDebugTargetView
implements ScopeSlotEditingSupport.ITypeSystemProvider {
    public static final String ID = "com.yakindu.sct.simulation.ui.declarationview";
    private TreeViewer executionContextViewer;
    private TreeViewer simulationSessionViewer;
    private Clock clock;
    private ViewerRefresher viewerRefresher;
    private FormToolkit kit = new FormToolkit(Display.getDefault());
    private RaiseEventSelectionListener selectionListener;
    private ITypeSystem typeSystem;
    private ISelectionChangedListener selectionChangedListener;
    private ThreadGroup raiseEventThreadGroup;

    public SimulationView() {
        this.kit.setBorderStyle(2048);
        this.raiseEventThreadGroup = new ThreadGroup("Raise Event ThreadGroup");
        this.raiseEventThreadGroup.setMaxPriority(1);
    }

    @Override
    public void dispose() {
        this.selectionListener.dispose();
        this.disposeViewerRefresher();
        super.dispose();
    }

    protected void disposeViewerRefresher() {
        if (this.viewerRefresher != null) {
            this.viewerRefresher.cancel = true;
            this.viewerRefresher = null;
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        Composite top = this.kit.createComposite(parent);
        top.setLayout((Layout)new GridLayout(2, false));
        SashForm sash = new SashForm(top, 66048);
        sash.setSashWidth(2);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sash);
        this.createSimulationSessionViewer((Composite)sash);
        this.createExecutionContextViewer((Composite)sash);
        sash.setWeights(new int[]{1, 5});
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.addSimulationSessionActions((IContributionManager)mgr);
        this.addSimulationSessions();
    }

    protected void addSimulationSessions() {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (this.isStatechartSimulationLaunch(launch)) {
                this.sessionViewerInputChanged(launch, false);
            }
            ++n2;
        }
    }

    public void setFocus() {
        this.executionContextViewer.getTree().setFocus();
    }

    protected void createSimulationSessionViewer(Composite parent) {
        this.simulationSessionViewer = SimulationSessionViewerFactory.createViewer(parent);
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((StructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof IDebugTarget) {
                    SimulationView.this.changeTarget((IDebugTarget)selection);
                } else if (selection instanceof ILaunch) {
                    SimulationView.this.changeTarget(((ILaunch)selection).getDebugTarget());
                }
                SourceLookupManager.getDefault().displaySource(selection, SimulationView.this.getSite().getPage(), true);
            }
        };
        this.simulationSessionViewer.addSelectionChangedListener(this.selectionChangedListener);
        MenuManager contextMenu = new MenuManager();
        this.addSimulationSessionActions((IContributionManager)contextMenu);
        Menu menu = contextMenu.createContextMenu(this.simulationSessionViewer.getControl());
        this.simulationSessionViewer.getControl().setMenu(menu);
    }

    protected void createExecutionContextViewer(Composite parent) {
        Composite contextViewerComposite = this.kit.createComposite(parent);
        contextViewerComposite.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(contextViewerComposite, 8519744);
        GridDataFactory.fillDefaults().align(0x1000008, 4).grab(true, false).applyTo((Control)toolBar);
        this.executionContextViewer = ExecutionContextViewerFactory.createViewer(contextViewerComposite, false, this);
        this.selectionListener = new RaiseEventSelectionListener(this.executionContextViewer, this.raiseEventThreadGroup);
        ToolBarManager manager = new ToolBarManager(toolBar);
        manager.add((IContributionItem)new ControlContribution("clock"){

            protected Control createControl(Composite parent) {
                if (SimulationView.this.clock == null) {
                    SimulationView.this.clock = new Clock(parent);
                }
                return SimulationView.this.clock;
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new ActionContributionItem((IAction)new ExpandAllAction(this.executionContextViewer)));
        manager.add((IContributionItem)new ActionContributionItem((IAction)new CollapseAllAction(this.executionContextViewer)));
        manager.add((IContributionItem)new ActionContributionItem((IAction)new HideTimeEventsAction(false)));
        manager.update(true);
        toolBar.pack();
    }

    @Override
    public void launchChanged(ILaunch launch) {
        if (this.isStatechartSimulationLaunch(launch)) {
            this.sessionViewerInputChanged(launch, true);
        }
        super.launchChanged(launch);
    }

    private void sessionViewerInputChanged(ILaunch changedLaunch, boolean select) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        ArrayList activeLaunches = Lists.newArrayList();
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (!launch.isTerminated() && this.isStatechartSimulationLaunch(launch)) {
                activeLaunches.add(launch);
            }
            ++n2;
        }
        Display.getDefault().asyncExec(() -> {
            try {
                this.simulationSessionViewer.removeSelectionChangedListener(this.selectionChangedListener);
                this.simulationSessionViewer.setInput((Object)activeLaunches.toArray());
                this.simulationSessionViewer.expandAll();
            }
            finally {
                this.simulationSessionViewer.addSelectionChangedListener(this.selectionChangedListener);
                if (changedLaunch != null && select) {
                    this.simulationSessionViewer.setSelection((ISelection)new StructuredSelection((Object)changedLaunch));
                }
            }
        });
    }

    protected boolean isStatechartSimulationLaunch(ILaunch launch) {
        return launch.getDebugTarget() instanceof SCTDebugTarget;
    }

    protected void setExecutionContextInput(Object input) {
        if (this.viewerRefresher == null) {
            this.viewerRefresher = new ViewerRefresher();
            this.viewerRefresher.setCancel(true);
        }
        Display.getDefault().asyncExec(() -> {
            if (input == null) {
                this.viewerRefresher.cancel = true;
            } else if (this.viewerRefresher.isCancel()) {
                this.viewerRefresher.cancel = false;
                new Thread(this.viewerRefresher).start();
            }
            this.executionContextViewer.setInput(input);
            this.executionContextViewer.expandToLevel(2);
        });
    }

    @Override
    protected void handleDebugEvent(DebugEvent debugEvent) {
        this.updateActions();
        switch (debugEvent.getKind()) {
            case 8: {
                this.setExecutionContextInput(null);
                Display.getDefault().asyncExec(() -> {
                    this.sessionViewerInputChanged(null, true);
                    if (this.clock != null && !this.clock.isDisposed()) {
                        this.clock.updateTimestamp(0L);
                    }
                });
                this.raiseEventThreadGroup.interrupt();
                break;
            }
            case 2: {
                Display.getDefault().asyncExec(() -> this.simulationSessionViewer.refresh());
                break;
            }
            case 1: {
                Display.getDefault().asyncExec(() -> this.simulationSessionViewer.refresh());
            }
        }
    }

    @Override
    protected void activeTargetChanged(IDebugTarget debugTarget) {
        DebugEvent debugEvent = new DebugEvent((Object)debugTarget, 16);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
        this.openEditorForTarget(debugTarget);
        this.updateTypeSystem(debugTarget);
        ISimulationEngine engine = (ISimulationEngine)debugTarget.getAdapter(ISimulationEngine.class);
        this.setExecutionContextInput(engine.getExecutionContext());
        this.updateActions();
    }

    protected void openEditorForTarget(IDebugTarget debugTarget) {
        EObject adapter;
        if (this.debugTarget != null && debugTarget instanceof SCTDebugTarget && ((SCTDebugTarget)debugTarget).isPrimary() && (adapter = (EObject)debugTarget.getAdapter(EObject.class)) instanceof Statechart) {
            Statechart statechart = (Statechart)adapter;
            final Diagram diagram = DiagramPartitioningUtil.getDiagramContaining((EObject)statechart);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiagramPartitioningUtil.openEditor((Diagram)diagram);
                }
            });
        }
    }

    protected void updateActions() {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = this.getViewSite().getActionBars().getToolBarManager().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (iContributionItem instanceof ActionContributionItem) {
                IAction currentAction = ((ActionContributionItem)iContributionItem).getAction();
                currentAction.setEnabled(currentAction.isEnabled());
            }
            ++n2;
        }
    }

    private void updateTypeSystem(IDebugTarget debugTarget) {
        IDomain domain = DomainRegistry.getDomain((EObject)((EObject)debugTarget.getAdapter(EObject.class)));
        if (domain != null) {
            this.typeSystem = (ITypeSystem)domain.getInjector("com.yakindu.sct.simulation", new String[0]).getInstance(ITypeSystem.class);
        }
    }

    protected void addSimulationSessionActions(IContributionManager mgr) {
        this.addActions(mgr, Lists.newArrayList((Object[])new DebugCommandAction[]{new ResumeAction(), new SuspendAction(), new StepOverAction()}));
        this.addActions(mgr, Lists.newArrayList((Object[])new DebugCommandAction[]{new TerminateAction(), new TerminateAndRelaunch()}));
        this.addActions(mgr, Lists.newArrayList((Object[])new DebugCommandAction[]{new RestartAction()}));
        mgr.update(true);
    }

    protected void addActions(IContributionManager mgr, ArrayList<DebugCommandAction> actions) {
        if (actions.isEmpty()) {
            return;
        }
        for (DebugCommandAction action : actions) {
            mgr.add((IAction)action);
        }
        this.updateActions();
        mgr.add((IContributionItem)new Separator());
    }

    @Override
    public ITypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    protected static class RaiseEventSelectionListener {
        private TreeViewer viewer;
        private Point mouseLocation;
        MouseMoveListener moveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                mouseLocation = new Point(e.x, e.y);
            }
        };
        MouseAdapter clickListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ViewerCell cell = viewer.getCell(mouseLocation);
                if (cell == null || cell.getColumnIndex() != 0) {
                    return;
                }
                Object element = cell.getElement();
                if (element instanceof ExecutionEvent) {
                    this.raiseEvent((ExecutionEvent)element);
                }
            }
        };
        private ThreadGroup raiseEventThreads;

        public RaiseEventSelectionListener(TreeViewer viewer, ThreadGroup raiseEventThreadGroup) {
            this.viewer = viewer;
            this.raiseEventThreads = raiseEventThreadGroup;
            this.registerMouseListener();
        }

        public void dispose() {
            if (!this.viewer.getControl().isDisposed()) {
                this.viewer.getControl().removeMouseMoveListener(this.moveListener);
                this.viewer.getControl().removeMouseListener((MouseListener)this.clickListener);
            }
        }

        protected void registerMouseListener() {
            this.viewer.getControl().addMouseMoveListener(this.moveListener);
            this.viewer.getControl().addMouseListener((MouseListener)this.clickListener);
        }

        public void raiseEvent(ExecutionEvent event) {
            Object payload;
            InterpreterSession session = InterpreterSession.SessionAdapter.session((EObject)event);
            Object object = payload = event instanceof ReferenceExecutionEvent ? ((ReferenceExecutionEvent)event).getReference() : event.getValue();
            if (session != null) {
                session.raiseEvent((Object)event, payload);
            } else {
                new Thread(this.raiseEventThreads, () -> {
                    IInterpreter interpreter = InterpreterAdapter.interpreter((EObject)event);
                    if (interpreter != null) {
                        interpreter.raiseEvent((Object)event, payload);
                    } else {
                        event.setRaised(!event.isRaised());
                    }
                }, "Raise Event " + event.getName()).start();
                this.viewer.refresh();
            }
        }
    }

    protected class RestartAction
    extends RestartCommandAction
    implements IAction {
        protected RestartAction() {
        }

        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ILaunchConfiguration launchConfiguration = ((RestartAction)RestartAction.this).SimulationView.this.debugTarget.getLaunch().getLaunchConfiguration();
                    DebugUITools.launch((ILaunchConfiguration)launchConfiguration, (String)((RestartAction)RestartAction.this).SimulationView.this.debugTarget.getLaunch().getLaunchMode());
                }
            });
        }

        public boolean isEnabled() {
            return SimulationView.this.debugTarget != null;
        }
    }

    protected class ResumeAction
    extends ResumeCommandAction
    implements IAction {
        protected ResumeAction() {
        }

        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDebugTarget[] debugTargets;
                        IDebugTarget[] iDebugTargetArray = debugTargets = ((ResumeAction)ResumeAction.this).SimulationView.this.debugTarget.getLaunch().getDebugTargets();
                        int n = debugTargets.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IDebugTarget current = iDebugTargetArray[n2];
                            current.resume();
                            ++n2;
                        }
                    }
                    catch (DebugException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        public boolean isEnabled() {
            return SimulationView.this.debugTarget != null && SimulationView.this.debugTarget.canResume();
        }
    }

    protected class StepOverAction
    extends StepOverCommandAction
    implements IAction {
        protected StepOverAction() {
        }

        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IDebugTarget[] debugTargets;
                    IDebugTarget[] iDebugTargetArray = debugTargets = ((StepOverAction)StepOverAction.this).SimulationView.this.debugTarget.getLaunch().getDebugTargets();
                    int n = debugTargets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDebugTarget current = iDebugTargetArray[n2];
                        if (current instanceof IStep) {
                            try {
                                ((IStep)current).stepOver();
                            }
                            catch (DebugException e) {
                                e.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                }
            });
        }

        public boolean isEnabled() {
            return SimulationView.this.debugTarget != null && SimulationView.this.debugTarget instanceof IStep && ((IStep)SimulationView.this.debugTarget).canStepOver();
        }
    }

    protected class SuspendAction
    extends SuspendCommandAction
    implements IAction {
        protected SuspendAction() {
        }

        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDebugTarget[] debugTargets;
                        IDebugTarget[] iDebugTargetArray = debugTargets = ((SuspendAction)SuspendAction.this).SimulationView.this.debugTarget.getLaunch().getDebugTargets();
                        int n = debugTargets.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IDebugTarget current = iDebugTargetArray[n2];
                            current.suspend();
                            ++n2;
                        }
                    }
                    catch (DebugException e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        public boolean isEnabled() {
            return SimulationView.this.debugTarget != null && SimulationView.this.debugTarget.canSuspend();
        }
    }

    protected class TerminateAction
    extends com.yakindu.sct.simulation.ui.actions.TerminateAction
    implements IAction {
        protected TerminateAction() {
        }

        @Override
        public IDebugTarget getDebugTarget() {
            return SimulationView.this.debugTarget;
        }
    }

    protected class TerminateAndRelaunch
    extends TerminateAndRelaunchAction
    implements IAction {
        protected TerminateAndRelaunch() {
        }

        @Override
        public IDebugTarget getDebugTarget() {
            return SimulationView.this.debugTarget;
        }
    }

    protected class ViewerRefresher
    implements Runnable {
        private static final long UPDATE_INTERVAL = 100L;
        private boolean cancel = false;

        protected ViewerRefresher() {
        }

        @Override
        public void run() {
            while (!this.cancel) {
                try {
                    Thread.sleep(100L);
                    Display.getDefault().asyncExec(() -> {
                        if (SimulationView.this.executionContextViewer != null && !SimulationView.this.executionContextViewer.getControl().isDisposed() && ((ExecutionContextContentProvider)SimulationView.this.executionContextViewer.getContentProvider()).isShouldUpdate()) {
                            ISimulationEngine engine;
                            SimulationView.this.executionContextViewer.refresh();
                            if (SimulationView.this.clock != null && !SimulationView.this.clock.isDisposed() && SimulationView.this.debugTarget != null && !SimulationView.this.debugTarget.isTerminated() && (engine = (ISimulationEngine)SimulationView.this.debugTarget.getLaunch().getDebugTarget().getAdapter(ISimulationEngine.class)).getTimeTaskScheduler() != null) {
                                SimulationView.this.clock.updateTimestamp(engine.getTimeTaskScheduler().getCurrentTime());
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public boolean isCancel() {
            return this.cancel;
        }

        public void setCancel(boolean cancel) {
            this.cancel = cancel;
        }
    }
}

