/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sctunit.coverage.ui.preferences;

import com.yakindu.sctunit.simulation.core.launch.ISCTUnitLaunchParameters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CoverageLaunchConfigurationTab
extends JavaLaunchTab
implements ISCTUnitLaunchParameters {
    private Button coverageCheckbox;
    private Button hideCoverageFilesCheckbox;
    private Text inputField;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout(3, false));
        comp.setLayoutData((Object)new GridData(1));
        Label titleLabel = new Label(comp, 0);
        titleLabel.setText("Coverage Options");
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        titleLabel.setLayoutData((Object)gridData);
        this.coverageCheckbox = new Button(comp, 32);
        this.coverageCheckbox.setText("Generate coverage files");
        this.coverageCheckbox.setLayoutData((Object)gridData);
        this.hideCoverageFilesCheckbox = new Button(comp, 32);
        this.hideCoverageFilesCheckbox.setText("Hide coverage files");
        this.hideCoverageFilesCheckbox.setLayoutData((Object)gridData);
        Label inputLabel = new Label(comp, 0);
        inputLabel.setText("Max number of coverage files to be stored:");
        inputLabel.setLayoutData((Object)new GridData(1));
        this.inputField = new Text(comp, 0);
        this.inputField.setTextLimit(100);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.inputField.setLayoutData((Object)gridData);
        this.coverageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoverageLaunchConfigurationTab.this.setDirty(true);
                CoverageLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.hideCoverageFilesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoverageLaunchConfigurationTab.this.setDirty(true);
                CoverageLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.inputField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("[1-9]*");
            }
        });
        this.inputField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CoverageLaunchConfigurationTab.this.setDirty(true);
                CoverageLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean generateCoverage = configuration.getAttribute("generateCoverage", true);
            this.coverageCheckbox.setSelection(generateCoverage);
            boolean hideFiles = configuration.getAttribute("hideCoverageFiles", true);
            this.hideCoverageFilesCheckbox.setSelection(hideFiles);
            int maxNumFiles = configuration.getAttribute("numberOfCoverageFilesToStore", 5);
            this.inputField.setText(Integer.toString(maxNumFiles));
        }
        catch (CoreException e) {
            this.coverageCheckbox.setSelection(true);
            this.hideCoverageFilesCheckbox.setSelection(true);
            this.inputField.setText(Integer.toString(5));
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("generateCoverage", true);
        configuration.setAttribute("hideCoverageFiles", false);
        configuration.setAttribute("numberOfCoverageFilesToStore", 5);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("generateCoverage", this.coverageCheckbox.getSelection());
        configuration.setAttribute("hideCoverageFiles", this.hideCoverageFilesCheckbox.getSelection());
        String fieldText = this.inputField.getText();
        if (fieldText != "") {
            configuration.setAttribute("numberOfCoverageFilesToStore", Integer.parseInt(fieldText));
        }
    }

    public String getName() {
        return "Coverage";
    }
}

