/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.typesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.yakindu.base.types.Property;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypeSpecifier;
import com.yakindu.base.types.TypesFactory;
import com.yakindu.base.types.typesystem.ITypeSystem;
import com.yakindu.sct.model.sgen.util.BuiltinDeclarationNames;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Singleton
@Accessors(value={AccessorType.PUBLIC_GETTER})
public class BuiltinDeclarations
implements BuiltinDeclarationNames {
    protected TypesFactory typesFactory = TypesFactory.eINSTANCE;
    protected ITypeSystem typeSystem;
    protected Property sct_version;
    protected Property sct_file;
    protected Property timestamp;
    protected Property hostname;
    protected Property username;
    protected Property sha256;
    protected Resource builtinResource;

    @Inject
    public BuiltinDeclarations(ITypeSystem typeSystem) {
        this.typeSystem = typeSystem;
        XMIResourceImpl _xMIResourceImpl = new XMIResourceImpl();
        this.builtinResource = _xMIResourceImpl;
        Type stringtype = typeSystem.getType("string");
        this.sct_version = this.createProperty("SCTVERSION", stringtype);
        this.timestamp = this.createProperty("TIMESTAMP", stringtype);
        this.hostname = this.createProperty("HOSTNAME", stringtype);
        this.username = this.createProperty("USER", stringtype);
        this.sct_file = this.createProperty("SCTFILE", stringtype);
        this.sha256 = this.createProperty("SHA256", stringtype);
    }

    protected Property createProperty(String name, Type type) {
        Property _createProperty = this.typesFactory.createProperty();
        Procedures.Procedure1 _function = prop -> {
            EList _contents = this.builtinResource.getContents();
            _contents.add(prop);
            prop.setName(name);
            TypeSpecifier _createTypeSpecifier = this.typesFactory.createTypeSpecifier();
            Procedures.Procedure1 _function_1 = it -> it.setType(type);
            TypeSpecifier _doubleArrow = (TypeSpecifier)ObjectExtensions.operator_doubleArrow((Object)_createTypeSpecifier, (Procedures.Procedure1)_function_1);
            prop.setTypeSpecifier(_doubleArrow);
            prop.setConst(false);
            prop.setReadonly(false);
        };
        return (Property)ObjectExtensions.operator_doubleArrow((Object)_createProperty, (Procedures.Procedure1)_function);
    }

    public List<Property> getGlobalDeclarations() {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Property[]{this.sct_version, this.timestamp, this.hostname, this.username}));
    }

    public List<Property> getStatechartLocalDeclarations() {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Property[]{this.sct_file, this.sha256}));
    }

    @Pure
    public TypesFactory getTypesFactory() {
        return this.typesFactory;
    }

    @Pure
    public ITypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Pure
    public Property getSct_version() {
        return this.sct_version;
    }

    @Pure
    public Property getSct_file() {
        return this.sct_file;
    }

    @Pure
    public Property getTimestamp() {
        return this.timestamp;
    }

    @Pure
    public Property getHostname() {
        return this.hostname;
    }

    @Pure
    public Property getUsername() {
        return this.username;
    }

    @Pure
    public Property getSha256() {
        return this.sha256;
    }

    @Pure
    public Resource getBuiltinResource() {
        return this.builtinResource;
    }
}

