/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.debugging.ui;

import com.yakindu.base.gmf.runtime.decorators.AbstractMarkerBasedDecorationProvider;
import com.yakindu.sct.simulation.ui.SimulationImages;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor;

public class BreakpointDecorationProvider
extends AbstractMarkerBasedDecorationProvider {
    private static final String BREAKPOINT_ID = "com.yakindu.sct.simulation.ui.breakpoints";

    protected boolean shouldInstall(IEditorPart part) {
        return part instanceof StatechartDiagramEditor;
    }

    protected String getDecoratorKey() {
        return BREAKPOINT_ID;
    }

    protected AbstractMarkerBasedDecorationProvider.StatusDecorator createStatusDecorator(IDecoratorTarget decoratorTarget) {
        return new BreakpointStatusDecorator(decoratorTarget);
    }

    public static class BreakpointStatusDecorator
    extends AbstractMarkerBasedDecorationProvider.StatusDecorator {
        public BreakpointStatusDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
        }

        private Image getImage(IMarker marker) {
            boolean enabled = marker.getAttribute("org.eclipse.debug.core.enabled", false);
            return enabled ? SimulationImages.BREAKPOINT_ENABLED.image() : SimulationImages.BREAKPOINT_DISABLED.image();
        }

        protected String getMarkerType() {
            return "com.yakindu.sct.simulation.debugging.breakpoints";
        }

        protected void createDecorators(View view, List<IMarker> markers) {
            String elementId = ViewUtil.getIdStr((View)view);
            if (elementId == null) {
                return;
            }
            for (IMarker marker : markers) {
                String attribute = marker.getAttribute("elementId", "");
                if (!attribute.equals(elementId)) continue;
                if (view instanceof Edge) {
                    this.setDecoration(this.getDecoratorTarget().addConnectionDecoration(this.getImage(marker), 75, true));
                } else {
                    this.setDecoration(this.getDecoratorTarget().addShapeDecoration(this.getImage(marker), IDecoratorTarget.Direction.NORTH_WEST, -1, true));
                }
                Label toolTip = new Label(marker.getAttribute("message", "Breakpoint"), this.getImage(marker));
                this.getDecoration().setToolTip((IFigure)toolTip);
            }
        }
    }
}

