/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
package com.yakindu.sct.domain.common

import org.eclipse.emf.ecore.util.EcoreUtil
import org.eclipse.xtext.EcoreUtil2
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.stext.stext.ImportScope
import com.yakindu.base.types.Declaration

class ExternalIncludes {
	
	def includeFiles(ExecutionFlow it) {
		EcoreUtil.CrossReferencer.find(
			EcoreUtil2::eAllContentsAsList(it)
			/* filter all elements which are contained in an ImportScope, 
			so we'll get PackageMembers which are really used in the current model and get rid of unused includes*/
			.filter[EcoreUtil2.getContainerOfType(it,ImportScope)===null]
			.toList
		).values
		.flatten
		.map[get(false)]
		.filter(Declaration)
		.filter[m | m.eAdapters.filter(FileLocationAdapter).size > 0]
		.map[t | t.eAdapters.filter(FileLocationAdapter).head.name]
		.toSet
	}
}
