/**
 * Copyright (c) 2022-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.core.codemodel
/**
 * This extension defines the state machine class. 
 * 
 * @author axel terfloth - Initial contribution.
 */

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypesFactory
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sexec.transformation.SexecElementMapping
import com.yakindu.sct.model.sgraph.Statechart
import org.eclipse.emf.ecore.EObject
import com.yakindu.base.types.adapter.OriginTracing

@Singleton
class StatemachineClass {

	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	@Inject protected extension TypeBuilder
	@Inject protected extension INamingService
	@Inject protected extension SExecExtensions
	@Inject protected extension SexecElementMapping
	@Inject protected extension StateEnum
	@Inject protected extension OriginTracing
	
	public static final String STATEMACHINE_CLASS_TYPE = "__statemachine_class_type__"
	
	def isStatemachineClass(ComplexType it) {
		getAnnotationOfType(STATEMACHINE_CLASS_TYPE) !== null
	}
	
	def stateMachineClass(ExecutionFlow flow) {
		flow.statechart.stateMachineClass
	}
	
	def ComplexType stateMachineClass(EObject it){
		if(it === null) return null
		if(it instanceof Statechart) return stateMachineClass
		val foundContainer = eContainerOfType(ComplexType)
		if(foundContainer !== null && foundContainer.isStatemachineClass)
			foundContainer
		else if(foundContainer instanceof ExecutionFlow)
			foundContainer.stateMachineClass
		else if(origin instanceof Statechart)
			(origin as Statechart).stateMachineClass
		else
			it.eContainer.stateMachineClass
	}
	
	def create e : createComplexType  stateMachineClass(Statechart sc) {
		
		e => [
			it.name = sc.stateMachineClassName
			val pkg = sc.getStatechartNamespace
				.map[ ns | createPackage => [it.name = ns]]
				.reduce[p1, p2| p1.member += p2 return p2]
				
			if (pkg !== null)
				pkg.member += it		
		]
		sc.defineStateEnum
		e._annotate(STATEMACHINE_CLASS_TYPE)
	}  
	
	def protected stateMachineClassName(Statechart it) {
		name.asIdentifier.toFirstUpper
	}
	
	def protected getStatechartNamespace(Statechart it) {
		if(it === null) {
			return emptyList
		}
		var ns = it.namespace
		if(ns === null || ns == "") {
			return emptyList
		}
		namespace.split(". | /").filter[!nullOrEmpty]
	}
		
}
