package com.yakindu.sct.generator.core.tracing

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.itemis.create.base.generator.core.codepattern.IEnumCode
import com.itemis.create.base.generator.core.concepts.Documentation
import com.yakindu.base.base.NamedElement
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.TypesFactory
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.Map

@Singleton
class TraceEvent {

	public static final String TRACE_EVENT_TYPE_ENUM_NAME = "TraceEventType"
	
	public static final String TRACE_FEATURE_SUFFIX = "Feature"

	public static final Map<String, String> TRACE_EVENT_TYPE_MAP = Map.ofEntries(
		Map.entry("TraceBeginRunCycle", "MACHINE_RTS_START"),
		Map.entry("TraceEndRunCycle", "MACHINE_RTS_STOP"),
		Map.entry("TraceReactionWillFire", "STATE_TRANSITION"),
		//Map.entry("TraceNodeExecuted", "STATE_TRANSITION"),
		//Map.entry("ReactionFired", "STATE_TRANSITION"),
		Map.entry("traceEnterCode", "MACHINE_ENTER"),
		Map.entry("traceExitCode", "MACHINE_EXIT"),
		Map.entry("TraceStateEntered", "STATE_ENTERED"),
		Map.entry("TraceStateExited", "STATE_EXITED"),
		Map.entry("EventDefinition", "EVENT_RAISED"),
		Map.entry("Property", "VARIABLE_SET"),
		Map.entry("ScheduleTimeEvent", "TIME_EVENT_SET"),
		Map.entry("UnscheduleTimeEvent", "TIME_EVENT_UNSET")
	);

	protected extension TypesFactory tFactory = TypesFactory.eINSTANCE
	@Inject protected extension IEnumCode
	@Inject protected extension SExecExtensions
	@Inject protected extension OriginTracing
	@Inject protected extension Documentation
	@Inject protected extension TypeBuilder
	@Inject protected extension GeneratorAssignment
	@Inject protected extension StatechartUtil

	def create e: createEnumerationType() traceEventType() {

		e.documentation("Enumeration of all types of origin tracing.")
		e._public
		e.name = TRACE_EVENT_TYPE_ENUM_NAME

		TRACE_EVENT_TYPE_MAP.values.forEach [ en |
			e.enumerator += createEnumerator => [
				it.name = en
			]
		]

		e.generateDefinitionWith[e.enumerationCode]

	}
	
	def create e: createEnumerationType() traceEventFeature(ComplexType ct) {

		e.documentation("Enumeration of all features of the statechart.")
		e._public
		e.name = ct.name + TRACE_FEATURE_SUFFIX

		ct.eAllContents.filter(TypedDeclaration).filter[originSource instanceof EventDefinition || originSource instanceof VariableDefinition].forEach [ en |
			e.enumerator += createEnumerator => [
				it.name = en.featureEnumMemberName
			]
		]

		e.generateDeclarationWith[e.enumerationCode]

	}
	
	def featureEnumMemberName(NamedElement it) {
		#[scope.defaultInterfaceName, name].filter[!nullOrEmpty].join("_").toUpperCase
	}
	
}
