/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
package com.yakindu.sct.generator.cpp.qt.templates

import com.yakindu.sct.generator.cpp.templates.ClassDeclaration
import java.util.List

class QtClassDeclaration extends ClassDeclaration {
	protected List<CharSequence> signals = newArrayList
	protected List<CharSequence> slots = newArrayList
	protected List<CharSequence> protectedSlots = newArrayList
	
	def signal(CharSequence signal) {
		signals.add(signal)
	}
	
	def slot(CharSequence slot) {
		slots.add(slot)
	}
	
	def protectedSlot(CharSequence slot) {
		protectedSlots.add(slot)
	}
	
	override generate() {
		if(name === null || name == "") {
			return ""
		}
		'''
		«IF comment !== null && comment != ""»
		«comment»
		«ENDIF»
		class «name»«IF !superTypes.empty» : «FOR sT : superTypes SEPARATOR ", "»«sT»«ENDFOR»«ENDIF»
		{
			«IF !(slots.empty && protectedSlots.empty && signals.empty) »
			Q_OBJECT
			
			«ENDIF»
			«IF !publicMembers.empty»
			public:
				«FOR member : publicMembers»
				«member»
				
				«ENDFOR»
				
			«ENDIF»
			«IF !slots.empty»
			public slots:
				«FOR member : slots»
				«member»
				
				«ENDFOR»
				
			«ENDIF»
			«IF !signals.empty»
			signals:
				«FOR member : signals»
				«member»
				
			«ENDFOR»
			
			«ENDIF»
			«IF !protectedMembers.empty»
			protected:
				«FOR member : protectedMembers»
				«member»
				
				«ENDFOR»
				
			«ENDIF»
			«IF !protectedSlots.empty»
			protected slots:
				«FOR member : protectedSlots»
				«member»
				
				«ENDFOR»
				
			«ENDIF»
			«IF !privateMembers.empty»
			private:
				«FOR member : privateMembers»
				«member»
				
				«ENDFOR»
				
			«ENDIF»
		};
		'''
	}
	
	
}