package com.yakindu.sct.json.transformation.model.util

import com.yakindu.sct.json.transformation.model.JsonCell
import com.yakindu.sct.json.transformation.model.JsonGraph
import com.yakindu.sct.json.transformation.model.JsonPosition
import com.yakindu.sct.json.transformation.model.JsonSize
import com.yakindu.sct.json.transformation.model.JsonTransition
import com.yakindu.sct.json.transformation.model.JsonTransitionAnchor
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil
import org.eclipse.gmf.runtime.notation.Bounds
import org.eclipse.gmf.runtime.notation.Diagram
import org.eclipse.gmf.runtime.notation.Edge
import org.eclipse.gmf.runtime.notation.Location
import org.eclipse.gmf.runtime.notation.Node
import org.eclipse.gmf.runtime.notation.NotationFactory
import org.eclipse.gmf.runtime.notation.RelativeBendpoints
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint

class NotationUtil {

	extension NotationFactory = NotationFactory.eINSTANCE

	def toRelativeBounds(JsonGraph graph, JsonCell cell) {

		val offset = graph.findParent(cell)?.position ?: new JsonPosition()
		createBounds => [
			if (cell.position !== null) {
				x = cell.position.x as int - offset.x as int 
				y = cell.position.y as int - offset.y as int - 20
			}
			// cell.size equals null -> use the default size
			if (cell.size !== null) {
				width = cell.size.width as int
				height = cell.size.height as int
			}
		]
	}

	def setBounds(JsonCell cell, Node view, JsonGraph graph) {
		if (view?.layoutConstraint === null || !(view.layoutConstraint instanceof Bounds))
			return;
		val notationBounds = view.layoutConstraint as Bounds
		cell.position = new JsonPosition => [
			x = notationBounds.x
			y = notationBounds.y
		]
		val parentPosition = graph.findParent(cell)?.position ?: JsonPosition.EMPTY
		cell.position.shift(parentPosition)
		if (notationBounds.width < 0 || notationBounds.height < 0) {
			cell.size = null
		} else
			cell.size = new JsonSize => [
				width = notationBounds.width
				height = notationBounds.height
			]
	}

	def createAnchor(JsonTransitionAnchor it) {
		// Extract dx, dy from args (assuming percentages as strings like "50%" or decimals as "0.5")
		val dxRaw = args.get("dx") + "" as String
		val dyRaw = args.get("dy") + "" as String
		val dx = convertPercent(dxRaw)
		val dy = convertPercent(dyRaw)
		createIdentityAnchor => [
			id = '''(«dx»,«dy»)'''
		]
	}

	// Convert dx/dy from "50%" to decimal between 0 and 1
	def protected convertPercent(String value) {
		if (value.endsWith("%")) {
			return Double.valueOf(value.substring(0, value.length - 1)) / 100
		}
		return Double.valueOf(value)
	}

	def Node findNotationView(EObject semanticElement, Diagram diagram, String type) {
		diagram.eAllContents().filter(Node).findFirst[it.type == type && EcoreUtil.equals(element, semanticElement)];
	}

	def Edge findNotationEdge(EObject semanticElement, Diagram diagram, String type) {
		diagram.eAllContents().filter(Edge).findFirst[it.type == type && EcoreUtil.equals(element, semanticElement)];
	}

	def List<JsonPosition> transformRelativeBendpoints(Edge edge, JsonCell source) {
		if (!(edge.bendpoints instanceof RelativeBendpoints))
			return newArrayList

		val bendpoints = (edge.bendpoints as RelativeBendpoints).points.filter(RelativeBendpoint).toList
		if (bendpoints.size < 2)
			return newArrayList
		bendpoints.subList(1, bendpoints.size - 1).map [ rp |
			new JsonPosition => [
				x = source.position.x + rp.sourceX
				y = source.position.y + rp.sourceY
			]
		].toList
	}

	def Location createLabelPosition(JsonTransition transition) {
		// <layoutConstraint xsi:type="notation:Location" xmi:id="_YfzWdjeaEeaQIqD3TyMHVw" x="-5" y="-10"/>
		createLocation => [
			x = 10
			y = 10
		]
	}

}
