/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.generator.base

import com.google.common.collect.Lists
import com.google.common.collect.Maps
import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.TimeEventSpec
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.util.SubchartDFS
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sct.model.stext.extensions.STextExtensions
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions
import java.util.List
import java.util.Map
import java.util.Stack
import org.eclipse.emf.ecore.util.EcoreUtil

abstract class AbstractSubchartInitializer extends SubchartDFS {
	@Inject
	protected extension BaseNamingExtensions
	
	@Inject
	protected extension STextExtensions
	
	@Inject
	protected extension StatechartAnnotations

	public var String initSequence = null
	
	public var String teardownSequence = null

	public var Map<Statechart, CharSequence> imports = null

	public var Stack<VariableDefinition> variableStack = null

	public var List<Statechart> subcharts = null

	public Statechart root

	abstract def void buildInitSequence(Statechart subchart, VariableDefinition element);
	
	abstract def void buildTeardownSequence(Statechart subchart, VariableDefinition element);

	def void buildImports(Statechart subchart) {}

	override beginVisit(Object element, Object parent, int depth) {
		if (element instanceof VariableDefinition) {
			val subchart = getStatechart(element)
			if (!EcoreUtil.equals(subchart, root) && !element.isInternal) {
				variableStack.push(element)
				buildInitSequence(subchart, element)
				buildTeardownSequence(subchart, element)
				buildImports(subchart)
				subcharts += subchart
			}
		}
	}
	

	override void endVisit(Object element, Object parent, int depth, int minDepth) {
		if (element instanceof VariableDefinition) {
			val subchart = getStatechart(element)
			if (!EcoreUtil.equals(subchart, root) && !element.isInternal) {
				variableStack.pop
			}
		}
	}

	override synchronized perform(Object root) {
		if(root instanceof Statechart) this.root = root

		initSequence = ""
		teardownSequence = ""
		imports = Maps.newHashMap
		variableStack = new Stack
		subcharts = Lists.newArrayList

		super.perform(root)
	}

	def getSubchartInitSequence(Statechart it) {
		initSequence ?: {
			perform
			initSequence
		}
	}
	
	def getSubchartTeardownSequence(Statechart it) {
		teardownSequence ?: {
			perform
			teardownSequence
		}
	}
	

	def getSubchartImports(Statechart it) {
		imports ?: {
			perform
			imports
		}
	}

	def getReferencedSubcharts(Statechart it) {
		subcharts ?: {
			perform
			subcharts
		}
	}
	
	
	
	def hasTimedSubchart(Statechart it) {
		referencedSubcharts.exists[isTimed]
	}
	
	def hasCycleBasedSubchart(Statechart it) {
		referencedSubcharts.exists[isCycleBased]
	}
	
	def needsTimer(Statechart it) {
		isCycleBased || timed || hasCycleBasedSubchart || hasTimedSubchart
	}
	
	def boolean isTimed(Statechart it) {
		eAllContents.filter(TimeEventSpec).size > 0
	}
	
	
}
