/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 */
package com.yakindu.sctunit.simulation.core.junit.serializer;

import com.google.inject.Singleton;
import com.yakindu.sctunit.simulation.core.junit.Failure;
import com.yakindu.sctunit.simulation.core.junit.TestCase;
import com.yakindu.sctunit.simulation.core.junit.TestSuite;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class JUnitXMLSerializer implements IJUnitXMLSerializer {
  @Override
  public String serialize(final TestSuite suite) {
    String _xifexpression = null;
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(suite.getTestSuites());
    if (_isNullOrEmpty) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("<testsuite name=\"");
      String _name = suite.getName();
      _builder.append(_name);
      _builder.append("\" time=\"");
      String _time = suite.getTime();
      _builder.append(_time);
      _builder.append("\">");
      _builder.newLineIfNotEmpty();
      {
        List<TestCase> _testCases = suite.getTestCases();
        for(final TestCase tcase : _testCases) {
          _builder.append("  ");
          _builder.append("<testcase name=\"");
          String _name_1 = tcase.getName();
          _builder.append(_name_1, "  ");
          _builder.append("\" classname=\"");
          String _className = tcase.getClassName();
          _builder.append(_className, "  ");
          _builder.append("\" time=\"");
          String _time_1 = tcase.getTime();
          _builder.append(_time_1, "  ");
          _builder.append("\">");
          _builder.newLineIfNotEmpty();
          {
            List<Failure> _failures = tcase.getFailures();
            for(final Failure failure : _failures) {
              _builder.append("  ");
              _builder.append("  ");
              _builder.append("<failure>");
              String _xML = this.toXML(failure.getMessage());
              _builder.append(_xML, "    ");
              _builder.append("</failure>");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("  ");
          _builder.append("</testcase>");
          _builder.newLine();
        }
      }
      _builder.append("</testsuite>");
      _builder.newLine();
      _xifexpression = _builder.toString();
    } else {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("<testsuite name=\"");
      String _name_2 = suite.getName();
      _builder_1.append(_name_2);
      _builder_1.append("\" time=\"");
      String _time_2 = suite.getTime();
      _builder_1.append(_time_2);
      _builder_1.append("\">");
      _builder_1.newLineIfNotEmpty();
      {
        List<TestSuite> _testSuites = suite.getTestSuites();
        for(final TestSuite tsuite : _testSuites) {
          _builder_1.append("  ");
          _builder_1.append("<testsuite name=\"");
          String _name_3 = tsuite.getName();
          _builder_1.append(_name_3, "  ");
          _builder_1.append("\" time=\"");
          String _time_3 = tsuite.getTime();
          _builder_1.append(_time_3, "  ");
          _builder_1.append("\">");
          _builder_1.newLineIfNotEmpty();
          {
            List<TestCase> _testCases_1 = tsuite.getTestCases();
            for(final TestCase tcase_1 : _testCases_1) {
              _builder_1.append("  ");
              _builder_1.append("  ");
              _builder_1.append("<testcase name=\"");
              String _name_4 = tcase_1.getName();
              _builder_1.append(_name_4, "    ");
              _builder_1.append("\" classname=\"");
              String _className_1 = tcase_1.getClassName();
              _builder_1.append(_className_1, "    ");
              _builder_1.append("\" time=\"");
              String _time_4 = tcase_1.getTime();
              _builder_1.append(_time_4, "    ");
              _builder_1.append("\">");
              _builder_1.newLineIfNotEmpty();
              {
                List<Failure> _failures_1 = tcase_1.getFailures();
                for(final Failure failure_1 : _failures_1) {
                  _builder_1.append("  ");
                  _builder_1.append("  ");
                  _builder_1.append("  ");
                  _builder_1.append("<failure>");
                  String _xML_1 = this.toXML(failure_1.getMessage());
                  _builder_1.append(_xML_1, "      ");
                  _builder_1.append("</failure>");
                  _builder_1.newLineIfNotEmpty();
                }
              }
              _builder_1.append("  ");
              _builder_1.append("  ");
              _builder_1.append("</testcase>");
              _builder_1.newLine();
            }
          }
          _builder_1.append("  ");
          _builder_1.append("</testsuite>");
          _builder_1.newLine();
        }
      }
      _builder_1.append("</testsuite>");
      _builder_1.newLine();
      _xifexpression = _builder_1.toString();
    }
    return _xifexpression;
  }

  protected String toXML(final String it) {
    return it.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
  }
}
