/**
 * Copyright (c) 2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.domain.c.runtime.exec

import com.google.inject.Inject
import com.yakindu.base.types.Type
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.c.typesystem.CTypeSystem
import com.yakindu.sct.model.sexec.extensions.SexecTypeSemantics

/**
 * In the C comain also pointers are considered as reference types.
 * 
 * @author Axel Terfloth
 */
class CDomainTypeSemantics extends SexecTypeSemantics {

	@Inject protected extension ITypeSystem 

	override isReferenceType(Type type) {
		type.isPointer || super.isReferenceType(type)
	}

	def protected isPointer(Type type) {
		isSame(type, getType(CTypeSystem.POINTER))
	}
	
}