/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.cpp

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.Event
import com.yakindu.base.types.Type
import com.yakindu.sct.generator.core.codemodel.NamedInterfaceClasses
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.stext.stext.StatechartScope
import com.yakindu.sct.model.stext.stext.VariableDefinition

@Singleton
class CppSpecifiers {
	
	@Inject protected extension SExecExtensions
	@Inject protected extension EventQueue
	@Inject protected extension NamedInterfaceClasses
	
	public static String NO_EXCEPTION = ""
	
	def _override(){
		''''''
	}
	
	def _explicit(){
		''''''
	}
	
	def _noexcept(){
		''''''
	}
	
	def _virtual(){
		'''virtual'''
	}
	
	def _const(){
		''''''
	}
	
	def _constexpr(Type it){
		''''''
	}
	
	def multiStmInclassInit(CharSequence it){
		''''''
	}
	
	def noException(AnnotatableElement it) {
		getAnnotationOfType(NO_EXCEPTION) !== null
	}
	
	def eventFuncThrowsException(Event it){
		if(!flow.eventDriven) _noexcept
	}
	
	def dispatch propertyThrowsException(ExecutionFlow it){
		if(!containsString) _noexcept
	}
	
	def dispatch propertyThrowsException(StatechartScope it){
		if(!containsString) _noexcept
	}
	
	def requiresObservable(){
		true
	}
	
	def requiresInitialization(VariableDefinition it){
		true
	}
	
	def requiresInitializationList(){
		true
	}
		
	def dispatch assignValue(CharSequence it) '''= «it»'''
	def dispatch assignValue(int it) '''= «it»'''
	
}