/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.cpp11

import com.yakindu.sct.generator.cpp.CppNamingService
import java.util.Arrays
import static com.yakindu.sct.generator.cpp.CppKeywords.*
import static com.yakindu.sct.generator.c.CKeywords.*
import com.google.inject.Singleton

@Singleton
class Cpp11NamingService extends CppNamingService {

	override asEscapedIdentifier(String it) {
		var s = it
		if (s.isKeyword) {
			s = s + separator + separator
		}
		return s.asIdentifier
	}
	
	
	
	override boolean isKeyword(String name) {
		return 
			!Arrays::asList(CPP_KEYWORDS).findFirst[it.equals(name)].nullOrEmpty
			|| !Arrays::asList(C_KEYWORDS).findFirst[it.equals(name)].nullOrEmpty
	}
	
}