/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11

import com.google.inject.Inject
import com.itemis.create.base.generator.core.GeneratorAssignment
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.cpp.providers.ISourceFragment
import com.yakindu.sct.generator.cpp.submodules.InterfaceFunctions
import com.yakindu.sct.generator.cpp11.codemodel.CodeModel
import com.yakindu.sct.model.sexec.ExecutionFlow

/**
 * @author axel terfloth
 */
class Cpp11PrivateClassMemberProvider implements ISourceFragment {
	
	@Inject protected extension CodeModel
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension GeneratorAssignment
	@Inject protected extension InterfaceFunctions
	

	override get(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) '''
		«FOR s : it.scopes»«IF !s.members.nullOrEmpty»«s.createUnnamedPrivateScope»«ENDIF»«ENDFOR»
		«FOR e : implementationClass.features.filter[isPrivate]»
			
			«e.declarationCode»
		«ENDFOR»
		
	'''	
	
}
