/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.cpp11.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.codepattern.IEnumCode
import com.yakindu.base.types.EnumerationType

/**
 * The implementation pattern for enum classes. 
 * 
 * @author axel terfloth - Initial contribution.
 */
class EnumClassCode implements IEnumCode {

	@Inject protected extension DoxygenComment
	
	override enumerationCode(EnumerationType it) '''
		
		«codeComment»
		enum class «it.name»
		{
			«FOR e : it.enumerator SEPARATOR ","»
				«e.name»
			«ENDFOR»
		};

	'''
	
}