/*
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/
package com.yakindu.sct.generator.java.features

import com.google.inject.Inject
import com.yakindu.base.types.Declaration
import com.yakindu.sct.generator.java.GeneratorPredicate
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.extensions.SExecExtensions

class Synchronized {
	@Inject protected extension GeneratorPredicate
	@Inject protected extension Naming
	@Inject protected extension SExecExtensions
	
	def sync() {
		if(needsSynchronized) "synchronized " else ""
	}
	
	def sync(String object, CharSequence code) {
		if(needsSynchronized) {
			'''
			synchronized(«object») {
				«code»
			}
			'''
		} else {
			code
		}
	}
		
	def syncObject(Declaration it) {
		if (isInNamedInterface)
			parentStatemachineInstance
		else
			flow.statemachineClassName + ".this"
	}
	
}