/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.library.impl

import static com.yakindu.base.types.typesystem.ITypeSystem.*
import com.yakindu.sct.generator.core.library.impl.CoreFeatureTypeLibraryProvider

class JavaFeatureTypeLibraryProvider extends CoreFeatureTypeLibraryProvider {

	def naming() {
		createFeatureType => [
			name = "Naming"
			optional = true
			parameters += createFeatureParameter => [
				name = "libraryPackage"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "basePackage"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "typeName"
				optional = true
				parameterType = getType(STRING)
			]
		]
	}

	def generalFeatures() {
		createFeatureType => [
			name = "GeneralFeatures"
			optional = true
			parameters += createFeatureParameter => [
				name = "RuntimeService"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "TimerService"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "VirtualTimerService"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "synchronized"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "runnable"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	def tracing() {
		createFeatureType => [
			name = "Tracing"
			optional = true
			parameters += createFeatureParameter => [
				name = "enterState"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "exitState"
				optional = true
				parameterType = getType(BOOLEAN)
			]
			parameters += createFeatureParameter => [
				name = "generic"
				optional = true
				parameterType = getType(BOOLEAN)
			]
		]
	}

	override provide() {
		create([super.provide]) => [
			name = "Java Generator"
			types += naming()
			types += generalFeatures()
			types += tracing()
		]
	}
}
