/**
* Copyright (c) 2022-2024 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Finlay Weegen - itemis AG
*
*/
 
package com.yakindu.sct.simulation.core.coverage

import com.yakindu.sct.simulation.core.coverage.Measurement.StateTransitionCoverage
import com.yakindu.sct.simulation.core.coverage.Measurement.TestCaseCount
import com.yakindu.sct.simulation.core.coverage.Measurement.Visits
import java.util.LinkedList

class MeasurementExtension {
			
	
	def Measurement forSubject(Measurement it, Object subject) {
		it.find([it.subject === subject])
	}

	def TestCaseCount testCaseCount(Measurement it) {
		return measures.filter(TestCaseCount).head
	}
	
	def Visits visits(Measurement it) {
		var visits = measures.filter(Visits).head

		if (visits === null) {
			visits = new Visits
			measures += visits
		}
		return visits
	}
	
	
	def StateTransitionCoverage coverage(Measurement it) {
		if (it === null) return null
		
		var coverage = it?.measures?.filter(StateTransitionCoverage)?.last
		if (coverage === null) {
			coverage = StateTransitionCoverage.ZERO
		}
		return coverage
	}

	
	/** Returns a measurement which fulfills the provided predicate. All parents are searched starting with the passed measurement itself. */
	def Measurement findParent(Measurement it, (Measurement)=>boolean predicate) {
		if (it !== null && predicate.apply(it)) return it
		return 
			if (parent !== null) parent.findParent(predicate)
			else null
	}

	/** Returns a measurement which fulfills the provided predicate. The passed measurement itself and its content (all children) are searched using a depth first search. */
	def Measurement find(Measurement it, (Measurement)=>boolean predicate) {
		if (it !== null && predicate.apply(it)) return it
		
		for (c : it.children) {
			val m = c.find(predicate)
			if(m !== null) return m
		}
		
		return null
	}
	
	/** Returns a measurement which fulfills the provided predicate. The passed measurement itself and its content (all children) are searched using a depth first search. */
	def Iterable<Measurement> findAll(Measurement it, (Measurement)=>boolean predicate) {
		
		var result = new LinkedList<Measurement>
		
		if (it !== null && predicate.apply(it)) result += it
		
		for (c : it.children) {
			result.addAll(c.findAll(predicate))
		}
		
		return result
	}
	
	
}
