/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.codepattern.BaseExpressionCode
import com.itemis.create.base.generator.core.codepattern.IMethodCode
import com.itemis.create.base.generator.core.types.Literals
import com.itemis.create.base.generator.csharp.codemodel.CsharpTypeBuilder
import com.itemis.create.base.generator.csharp.codemodel.CsharpVisibility
import com.yakindu.base.types.Operation

/**
 * The standard implementation pattern for method generation. 
 * 
 * @author laszlo kovacs - Initial contribution.
 */
class MethodCode implements IMethodCode {
	
	@Inject protected extension CsharpVisibility
	@Inject protected extension BaseExpressionCode
	@Inject protected extension CodeComment
	@Inject protected extension CsharpTypeBuilder	
	@Inject protected extension AttributeCode
	@Inject protected extension Literals
	
	override methodDefinitionCode(Operation it) '''
		«codeComment»
		«attributeCode»
		«it.csharpVisibility» «IF abstract»abstract«ENDIF» «typeSpecifier.asLiteral» «name»(«FOR p:parameters SEPARATOR ", "»«IF !iseventArgs»«p.typeSpecifier.asLiteral»«ENDIF» «p.name»«ENDFOR») «IF it.implementation === null»;«ELSE»«it.implementation.code» «ENDIF»
	'''
	
	override methodDeclarationCode(Operation it) '''
		«codeComment»
		«it.csharpVisibility» «declType» «typeSpecifier.asLiteral» «name»(«FOR p:parameters SEPARATOR ", "»«IF !iseventArgs»«p.typeSpecifier.asLiteral»«ENDIF» «p.name»«ENDFOR»);
	'''
	
	def notImplementedException() '''
	{ throw new NotImplementedException(); }'''
	
	
}
