/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.features

import com.yakindu.sct.generator.core.library.CoreGenmodelEntries
import com.yakindu.sct.model.sgen.FeatureParameterValue
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.itemis.create.base.generator.csharp.features.ICsharpFeatureConstants.*

class CsharpGenmodelEntries extends CoreGenmodelEntries {
	
	def protected getNamingFeature(GeneratorEntry it) {
		getFeatureConfiguration(NAMING_FEATURE)
	}

	def protected getGeneralFeatures(GeneratorEntry it) {
		getFeatureConfiguration(GENERAL_FEATURES)
	}
	
	def protected getCsharpFeatureParameter(GeneratorEntry it) {
		getFeatureConfiguration(CSHARP_FEATURES)
	}
	
	def protected FeatureParameterValue getCompilerPragmaParameter(GeneratorEntry it) {
		csharpFeatureParameter?.getParameterValue(COMPILER_PRAGMAS)
	}
	
	def getCompilerPragma(GeneratorEntry it) {
		if(getCompilerPragmaParameter !== null)
			getCompilerPragmaParameter.getStringValue
		else
			""
	}

	def protected FeatureParameterValue getBasePackageParameter(GeneratorEntry it) {
		namingFeature?.getParameterValue(BASE_NAMESPACE)
	}
	
	def protected FeatureParameterValue getLibraryPackageParameter(GeneratorEntry it) {
		namingFeature?.getParameterValue(LIBRARY_NAMESPACE)
	}
	
	def protected FeatureParameterValue getGeneratedFileExtensionParameter(GeneratorEntry it) {
		namingFeature?.getParameterValue(GENERATED_FILE_EXTENSION)
	}

	def protected FeatureParameterValue getTypeNameParameter(GeneratorEntry it) {
		namingFeature?.getParameterValue(TYPE_NAME)
	}

	def protected FeatureParameterValue getTimerServiceParameter(GeneratorEntry it) {
		generalFeatures?.getParameterValue(TIMER_SERVICE)
	}
	
	override getLibraryPackage(GeneratorEntry it) {
		libraryPackageParameter?.stringValue ?: LIBRARY_NAMESPACE_DEFAULT
	}

	def getTypeName(GeneratorEntry it) {
		typeNameParameter?.stringValue
	}
	
	def getgeneratedFileExtension(GeneratorEntry it) {
		if(getGeneratedFileExtensionParameter !== null)
			getGeneratedFileExtensionParameter.getBooleanValue	
		else
			false
	}

	def createTimerService(GeneratorEntry it) {
		if (timerServiceParameter !== null) {
			return timerServiceParameter.booleanValue
		}
		return false
	}
	
	def private getTracingFeature(GeneratorEntry it) {
		getFeatureConfiguration(FEATURE_TRACING)
	}
	
	def tracingGeneric(GeneratorEntry it) {
		val genericParameter = tracingFeature?.getParameterValue(PARAMETER_TRACING_GENERIC)
		if (genericParameter !== null) {
			return genericParameter.booleanValue
		}
		return false
			
	}
}
