/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.csharp.transformation

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.csharp.concepts.EventRaiser
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.ExpressionsFactory
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.core.codemodel.StatemachineClass
import com.yakindu.sct.generator.core.codemodel.StatemachineEvents
import com.yakindu.sct.model.sexec.Execution
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil
import com.yakindu.base.types.Operation

/**
 * In the code model of the target language events are raised by calling the event raiser method.
 * This modification substitutes EventRaisingExpressions by calls to those event raisers. 
 * 
 * @author Axel Terfloth
 */
@Singleton
class RaiseEventModification {
	
	@Inject protected extension EventRaiser
	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	@Inject protected extension OriginTracing
	@Inject protected extension ExpressionExtensions
	@Inject protected extension StatemachineClass
	@Inject protected extension StatemachineEvents
	
	protected extension ExpressionsFactory expFactory = ExpressionsFactory.eINSTANCE
	
	def substituteEventRaisingExpressionsByEventRaisers(EObject it) {
		eAllContents
			.filter(EventRaisingExpression)
			.toList
			.forEach[ 
				val econtainer = it.eContainer
				EcoreUtil.replace(it, raiser)
				if(econtainer instanceof Execution) econtainer.statement = raiser
			]
	}
	
	
	def protected dispatch ArgumentExpression raiser(EventRaisingExpression it) {
		event.raiser => [ raiser |
				if ( value !== null ) {
					raiser._with( value.copy )
				}
			]		
	}
	
	//TODO: Do not do magic here
	def protected dispatch ArgumentExpression raiser(ElementReferenceExpression it) {
		_call(
			if(reference instanceof Property){
				// As out events are transformed first to local and then local_out we have to get the original out event raiser (origin of origin)
				if(reference.originTraces.filter(Event).exists[direction === Direction.LOCAL] && 
					reference.originTraces.filter(Event).head.originTraces.filter(Event).exists[direction === Direction.OUT]
				)
					((reference.origin as EObject).origin as TypedDeclaration).eventRaiser
				else
					(reference.origin as TypedDeclaration).eventRaiser
			}
			else 
				(reference as TypedDeclaration).eventRaiser
		)
	}
	
	def protected dispatch ArgumentExpression raiser(FeatureCall it) {
		owner
		.copy
		._call(
			if(feature.originTraces.filter(Event).exists[direction === Direction.LOCAL] && feature instanceof Property)
				(feature.stateMachineClass.eAllContents.filter(Property).filter[c | 
					c.origin === feature.originTraces.filter(Event).filter[direction === Direction.LOCAL].head.origin
				].head.origin as TypedDeclaration).eventRaiser
			else if(feature instanceof Property)
				(feature.origin as TypedDeclaration).eventRaiser
			else if(feature instanceof Operation)
				feature as Operation
			else
				(feature as TypedDeclaration).eventRaiser
		)
	}
	
}