/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.itemis.create.base.generator.core.concepts

import com.google.inject.Inject
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.expressions.expressions.StringLiteral
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.TypeBuilder

/**
 * Extension that handles code comments via annotations. 
 * 
 * TODO: move to a new generator independent base modeling (slang?) module
 * 
 * @author axel terfloth - Initial contribution.
 */
class Documentation {
	
	@Inject protected extension TypeBuilder
	@Inject protected extension ExpressionBuilder
	
	public static String DOCUMENTATION_ANNOTATION = "__documentation__"
	public static String DOCUMENTATION_ARGUMENT = "text"
	
	def hasDocumentation(AnnotatableElement it){
		getAnnotationOfType(DOCUMENTATION_ANNOTATION) !== null		
	}
	
	def documentation(AnnotatableElement it){
		val currentDoc = documentationAnnotation
							?.arguments
							?.head
							?.value
							
		if ( currentDoc !== null) 
			if (currentDoc instanceof PrimitiveValueExpression) {
				val currentValue = currentDoc.value
				if (currentValue instanceof StringLiteral) 
					return currentValue.value
			}
			
		return null
	}
	
	def protected documentationAnnotation(AnnotatableElement it){
		annotations
			.filter[ a | a.type.name == DOCUMENTATION_ANNOTATION]
			.head	
	}
	
	def documentation(AnnotatableElement it, String text){
		
		if (documentationAnnotation !== null) {
			it.annotations.remove(documentationAnnotation)
		}
		
		it._annotate(_annotationType(DOCUMENTATION_ANNOTATION), text._string )
		
	}
}
