/**
 * Copyright (c) 2012-2022 committers of itemis CREATE and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     committers of itemis CREATE - initial API and implementation
 */
package com.yakindu.sct.model.sgraph.validation;

import com.yakindu.base.base.BasePackage
import com.yakindu.sct.model.sgraph.Statechart
import org.eclipse.xtext.validation.Check

/**
 * 
 * All validation contraints for the meta model element {@link Statechart}
 * 
 */
class StatechartValidator extends AbstractSGraphValidator {

	static final String STATECHART_NAME_MUST_BE_IDENTIFIER_MSG = "%s is not a valid identifier!";
	public static final String STATECHART_NAME_MUST_BE_IDENTIFIER_CODE = "statechart.name.MustBeIdentifier";

	@Check
	def checkStatechartNameMustBeIdentifier(Statechart statechart) {
		if (!isValidJavaIdentifier(statechart.getName())) {
			error(String.format(STATECHART_NAME_MUST_BE_IDENTIFIER_MSG, statechart.getName()), statechart,
					BasePackage.Literals.NAMED_ELEMENT__NAME, -1, STATECHART_NAME_MUST_BE_IDENTIFIER_CODE);

		}
	}

	def isValidJavaIdentifier(String s) {
		if (s === null || s.length() == 0) {
			return false;
		}
		var char[] c = s.toCharArray(); 
		if (!Character.isJavaIdentifierStart(c.get(0))) {
			return false;
		}
		for (var i = 1; i < c.length; i++) {
			if (!Character.isJavaIdentifierPart(c.get(i))) {
				return false;
			}
		}
		return true;
	}

}
