/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.AssignmentOperator
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.LogicalRelationExpression
import com.yakindu.base.expressions.expressions.MultiplicativeOperator
import com.yakindu.base.expressions.expressions.NumericalMultiplyDivideExpression
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.Expression
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.c.CExpressionsGenerator
import com.yakindu.sct.generator.c.types.CTypeAnnotations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.stext.stext.VariableDefinition

class ExpressionsChecker {

	@Inject protected extension CExpressionsGenerator
	@Inject protected extension CTypeAnnotations
	
	@Inject protected extension ITypeSystem
	@Inject protected extension ITypeSystemInferrer

	def modOnReal(ExecutionFlow it) {
		!eAllContents.filter(NumericalMultiplyDivideExpression).filter[operator == MultiplicativeOperator.MOD].filter [
			it.haveCommonTypeReal
		].isEmpty || !eAllContents.filter(AssignmentExpression).filter[operator == AssignmentOperator.MOD_ASSIGN].filter [
			it.haveCommonTypeReal
		].isEmpty
	}
	
	def hasCharArrayAssignment(ExecutionFlow it) {
		!eAllContents.filter(AssignmentExpression).filter[assignsCharArray].isEmpty
	}
	
	def protected assignsCharArray(AssignmentExpression it) {
		varRef instanceof FeatureCall && ((varRef as FeatureCall).feature as AnnotatableElement).hasCharArrayAnnotation
	}
	
	def hasStringComparison(ExecutionFlow it) {
		!eAllContents.filter(LogicalRelationExpression).filter[comparesString].isEmpty
	}
	
	def protected comparesString(LogicalRelationExpression it) {
		leftOperand.infer.type.isString || rightOperand.infer.type.isString
	}
	
	def isConstString(VariableDefinition it) {
		const && isStringType
	}
	
	def isStringType(VariableDefinition it) {
		isString(typeSpecifier.type)
	}
	
	
	def boolean haveCommonTypeReal(Expression expression) {
		!getCommonType(
				infer(expression).getType, getType(ITypeSystem.INTEGER)
			).isInteger
	}
}
