package com.yakindu.sct.generator.c.extensions

import com.google.inject.Inject
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart

import static com.yakindu.sct.generator.c.CGeneratorConstants.*

class FileNaming {
	
	@Inject GeneratorEntry entry
	@Inject protected extension GenmodelEntries
	@Inject protected extension GeneratorEntryProvider
	@Inject protected extension INamingService
	@Inject protected extension CTypes
	
	def module(ExecutionFlow it) {
		if (getEntry.moduleName.nullOrEmpty) {
			return name.asIdentifier
		}
		return getEntry.moduleName
	}
	
	def module(Statechart it) {
		if (getEntry.moduleName.nullOrEmpty) {
			return name.asIdentifier
		}
		return getEntry.moduleName
	}
	
	def String h(String it) '''«it».«entry.headerFilenameExtension»'''

	def String c(String it) '''«it».«entry.sourceFilenameExtension»'''
	
	def String h(String it, Statechart statechart) '''«it».«statechart.getEntry.headerFilenameExtension»'''

	def String c(String it, Statechart statechart) '''«it».«statechart.getEntry.sourceFilenameExtension»'''
	
	def tracingModule() {
		TRACING_MODULE
	}
	
	def rxcModule() {
		RXC_MODULE
	}
	
	def statemachineModule() {
		STATEMACHINE_MODULE
	}
	
	def timerServiceModule() {
		TIMER_SERVICE_MODULE
	}
	
	def metaModule(ExecutionFlow it) {
		it.module + META_MODULE
	}
	
	def typesModule() {
		sc_types.name
	}
	
	def client(String it) {
		it + "_required"
	}
	
	def getTypedRxcModule(TypeSpecifier it) {
		rxcModule + "_" + getTypeModuleName
	}
	
	def define(String it) { it.replaceAll('\\.', '_').toUpperCase }
	
	def String getTypeModuleName(TypeSpecifier it) {
		if(type.name == "pointer")
			return type.name + "_" + typeArguments.head.getTypeModuleName
		return type.name
	}
}