/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.files

import com.google.inject.Inject
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * @author Robin Herrmann
 */
class TypedRxCSource implements IContentTemplate<ExecutionFlow> {
	@Inject extension Naming
	@Inject protected extension FileNaming
	@Inject extension GenmodelEntries

	TypeSpecifier ts

	new(TypeSpecifier ts, Naming naming, FileNaming fileNaming, GenmodelEntries genmodelEntries) {
		this.ts = ts
		this._naming = naming
		this._fileNaming = fileNaming
		this._genmodelEntries = genmodelEntries
	}
	
	override content(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#include "«(ts.typedRxcModule.h).relativeTo(ts.typedRxcModule.c)»"
		
		define_sc_reactive_extensions(«ts.typeName»)

		'''
	}
}