/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.base.expressions.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BitwiseOperator implements Enumerator
{
    XOR(0, "xor", "^"),
    AND(1, "and", "&"),
    OR(2, "or", "|");

    public static final int XOR_VALUE = 0;
    public static final int AND_VALUE = 1;
    public static final int OR_VALUE = 2;
    private static final BitwiseOperator[] VALUES_ARRAY;
    public static final List<BitwiseOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BitwiseOperator[]{XOR, AND, OR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BitwiseOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BitwiseOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BitwiseOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BitwiseOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BitwiseOperator get(int value) {
        switch (value) {
            case 0: {
                return XOR;
            }
            case 1: {
                return AND;
            }
            case 2: {
                return OR;
            }
        }
        return null;
    }

    private BitwiseOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

