/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.examples.wizard.drop;

import com.yakindu.sct.examples.wizard.drop.ExampleDropTargetListener;
import com.yakindu.sct.examples.wizard.drop.IDropTargetInstaller;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ExampleDropTargetInstaller
implements IDropTargetInstaller {
    private final DropTargetAdapter dropListener = this.getDropTargetListener();
    private Transfer[] transferAgents;

    @Override
    public void installDropTarget(Shell shell) {
        this.hookUrlTransfer(shell, this.dropListener);
    }

    protected DropTargetAdapter getDropTargetListener() {
        return new ExampleDropTargetListener();
    }

    protected DropTarget hookUrlTransfer(Shell shell, DropTargetAdapter dropListener) {
        Control[] children;
        DropTarget target = this.findDropTarget((Control)shell);
        if (target != null) {
            this.registerWithExistingTarget(target);
        } else {
            target = new DropTarget((Control)shell, 23);
            if (this.transferAgents == null) {
                this.transferAgents = new Transfer[]{URLTransfer.getInstance()};
            }
            target.setTransfer(this.transferAgents);
        }
        this.registerDropListener(target, (DropTargetListener)dropListener);
        Control[] controlArray = children = shell.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.hookRecursive(child, (DropTargetListener)dropListener);
            ++n2;
        }
        return target;
    }

    protected void registerDropListener(DropTarget target, DropTargetListener dropListener) {
        target.removeDropListener(dropListener);
        target.addDropListener(dropListener);
    }

    protected void hookRecursive(Control child, DropTargetListener dropListener) {
        DropTarget childTarget = this.findDropTarget(child);
        if (childTarget != null) {
            this.registerWithExistingTarget(childTarget);
            this.registerDropListener(childTarget, dropListener);
        }
        if (child instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)child;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                this.hookRecursive(control, dropListener);
                ++n2;
            }
        }
    }

    protected void registerWithExistingTarget(DropTarget target) {
        Transfer[] transfers = target.getTransfer();
        boolean exists = false;
        if (transfers != null) {
            Transfer[] transferArray = transfers;
            int n = transfers.length;
            int n2 = 0;
            while (n2 < n) {
                Transfer transfer = transferArray[n2];
                if (transfer instanceof URLTransfer) {
                    exists = true;
                    break;
                }
                ++n2;
            }
            if (!exists) {
                Transfer[] newTransfers = new Transfer[transfers.length + 1];
                System.arraycopy(transfers, 0, newTransfers, 0, transfers.length);
                newTransfers[transfers.length] = URLTransfer.getInstance();
                target.setTransfer(newTransfers);
            }
        }
    }

    protected DropTarget findDropTarget(Control control) {
        Object object = control.getData("DropTarget");
        if (object instanceof DropTarget) {
            return (DropTarget)object;
        }
        return null;
    }
}

