/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.genmodel.ui.help;

import com.yakindu.base.utils.jface.help.AbstractUserHelpDocumentationProvider;
import com.yakindu.sct.model.sgen.FeatureConfiguration;
import com.yakindu.sct.model.sgen.FeatureParameter;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgraph.Statechart;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;

public class SGenUserHelpDocumentationProvider
extends AbstractUserHelpDocumentationProvider
implements IEObjectDocumentationProvider {
    private static final String PLUGIN_ID = "com.yakindu.sct.ui.editor";
    private static final String CONTEXT_ID = "sgen_feature";
    private static final String ITEMIS_CREATE_LABEL = "itemis CREATE";
    private static final Map<String, String> docuCache = new WeakHashMap<String, String>();

    public String getDocumentation(EObject o) {
        List<String> tags = this.getDocumentationTags(o);
        if (!tags.isEmpty()) {
            return this.getFeatureTypeDocumentation(tags);
        }
        if (o instanceof Statechart) {
            URI uri = EcoreUtil.getURI((EObject)o);
            return uri.isPlatform() ? uri.toPlatformString(true) : uri.toFileString();
        }
        return "";
    }

    public List<String> getDocumentationTags(EObject o) {
        FeatureType type = null;
        if (o instanceof FeatureConfiguration) {
            type = ((FeatureConfiguration)o).getType();
        } else if (o instanceof FeatureType) {
            type = (FeatureType)o;
        } else if (o instanceof FeatureParameter) {
            ArrayList<String> tags = new ArrayList<String>();
            tags.add(this.getDocumentationTag((FeatureParameter)o));
            return tags;
        }
        return this.getDocumentationTags(type);
    }

    protected List<String> getDocumentationTags(FeatureType type) {
        ArrayList<String> tags = new ArrayList<String>();
        if (type instanceof FeatureType) {
            tags.add(this.getDocumentationTag(type));
            for (FeatureParameter param : type.getParameters()) {
                tags.add(this.getDocumentationTag(param));
            }
        }
        return tags;
    }

    protected String getDocumentationTag(FeatureParameter param) {
        return ("sgen_feature_" + param.getFeatureType().getName() + "_" + this.getLibraryName(param) + "_" + param.getName()).toLowerCase();
    }

    protected String getDocumentationTag(FeatureType type) {
        return ("sgen_feature_" + type.getName() + "_" + this.getLibraryName(type)).toLowerCase();
    }

    protected String getLibraryName(FeatureType type) {
        return type.getDocumentationLibraryName().replaceAll("\\s+", "_");
    }

    protected String getLibraryName(FeatureParameter param) {
        return param.getDocumentationLibraryName().replaceAll("\\s+", "_");
    }

    protected String getFeatureTypeDocumentation(List<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return "";
        }
        IToc[] tocs = HelpSystem.getTocs();
        IToc ysctToc = null;
        IToc[] iTocArray = tocs;
        int n = tocs.length;
        int n2 = 0;
        while (n2 < n) {
            IToc toc = iTocArray[n2];
            String label = toc.getLabel();
            if (label.contains(ITEMIS_CREATE_LABEL)) {
                ysctToc = toc;
                break;
            }
            ++n2;
        }
        if (ysctToc == null) {
            return "";
        }
        ArrayList<String> docParts = new ArrayList<String>();
        Set<String> helpResources = this.getHelpResources(ysctToc);
        for (String name : tags) {
            for (String helpResource : helpResources) {
                String href = helpResource.substring(1);
                String userHelp = docuCache.get(href);
                if (userHelp == null) {
                    URL url;
                    try {
                        url = new URL("platform:/plugin/" + href);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                        continue;
                    }
                    try {
                        userHelp = this.convertStreamToString(url.openConnection().getInputStream());
                        docuCache.put(href, userHelp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                int beginIndex = userHelp.indexOf("<!-- Start " + name + " -->");
                int endIndex = userHelp.indexOf("<!-- End " + name + " -->");
                if (beginIndex >= 0 && endIndex >= 0 && endIndex > beginIndex) {
                    docParts.add(userHelp.substring(beginIndex, endIndex));
                    continue;
                }
                String baseFeatureName = name.substring(0, name.lastIndexOf("_"));
                if (tags.contains(baseFeatureName)) continue;
                beginIndex = userHelp.indexOf("<!-- Start " + baseFeatureName + " -->");
                endIndex = userHelp.indexOf("<!-- End " + baseFeatureName + " -->");
                if (beginIndex < 0 || endIndex < 0 || endIndex <= beginIndex) continue;
                docParts.add(userHelp.substring(beginIndex, endIndex));
            }
        }
        return String.join((CharSequence)"\n", docParts);
    }

    public ArrayList<String> getDocumentedFeatures() {
        ArrayList<String> features = new ArrayList<String>();
        String userHelp = this.getHelp("com.yakindu.sct.ui.editor.sgen_feature");
        Pattern p = Pattern.compile("\\Q<!-- Start _\\E(\\S+) -->");
        Matcher m = p.matcher(userHelp);
        while (m.find()) {
            features.add(m.group(1));
        }
        return features;
    }

    private Set<String> getHelpResources(IToc toc) {
        IUAElement[] children;
        HashSet<String> helpResources = new HashSet<String>();
        IUAElement[] iUAElementArray = children = toc.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IUAElement e = iUAElementArray[n2];
            this.addHelpResources(helpResources, e);
            ++n2;
        }
        return helpResources;
    }

    private void addHelpResources(Set<String> helpResources, IUAElement e) {
        if (e instanceof ITopic) {
            ITopic c = (ITopic)e;
            String href = c.getHref();
            if (href != null) {
                int hashPos = href.indexOf(35);
                if (hashPos > 0) {
                    href = href.substring(0, hashPos);
                }
                helpResources.add(href);
            }
            IUAElement[] iUAElementArray = c.getChildren();
            int n = iUAElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IUAElement e1 = iUAElementArray[n2];
                this.addHelpResources(helpResources, e1);
                ++n2;
            }
        }
    }
}

