/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal;

import com.yakindu.licmgmt.ILicenseEventListener;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.internal.LicenseService;
import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.utils.LicenseNotifications;
import com.yakindu.licmgmt.ui.notification.popup.NotificationService;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class LicenseManagementUiActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.yakindu.licmgmt.ui";
    private static final String EXTENSION_POINT_ID = "com.yakindu.licmgmt.ui.yakinduLicense";
    private static final String EXTENSION_ID = "yakinduLicense";
    private ImageRegistry imageRegistry;
    private static LicenseManagementUiActivator plugin;
    private List<AbstractLicenseFeature> licenseExtensions;
    private IPreferenceStore preferenceStore;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registerEventListener();
    }

    private void registerEventListener() {
        ((LicenseService)ILicenseService.INSTANCE).addEventListener((ILicenseEventListener)new LicenseNotifications());
    }

    private void loadYakinduLicenseExtensions() {
        IConfigurationElement[] elements;
        this.licenseExtensions = new LinkedList<AbstractLicenseFeature>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object extension = element.createExecutableExtension(EXTENSION_ID);
                if (extension instanceof AbstractLicenseFeature) {
                    this.licenseExtensions.add((AbstractLicenseFeature)extension);
                }
            }
            catch (Throwable e) {
                plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, "Failed to load itemis license extension from " + element.getContributor(), e));
            }
            ++n2;
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        NotificationService.stopIndication();
    }

    public static LicenseManagementUiActivator getDefault() {
        return plugin;
    }

    public List<AbstractLicenseFeature> getLicenseFeatures() {
        if (this.licenseExtensions == null) {
            this.loadYakinduLicenseExtensions();
        }
        return Collections.unmodifiableList(this.licenseExtensions);
    }

    public Image getImage(String imagePath) {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry(Display.getDefault());
        }
        if (this.imageRegistry.get(imagePath) == null) {
            Image img = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imagePath).createImage();
            this.imageRegistry.put(imagePath, img);
        }
        return this.imageRegistry.get(imagePath);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.yakindu.licmgmt.eclipse");
        }
        return this.preferenceStore;
    }

    public static void log(String message, int severity, Throwable throwable, boolean throwRuntimeException, boolean printStackTrace) {
        if (!Platform.isRunning()) {
            System.out.println("LicenseManagementUiActivator.log: " + message);
        } else {
            plugin.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message, throwable));
        }
        RuntimeException e = null;
        if (printStackTrace) {
            e = LicenseManagementUiActivator.initRuntimeException(message, throwable);
            e.printStackTrace();
        }
        if (throwRuntimeException) {
            throw e == null ? LicenseManagementUiActivator.initRuntimeException(message, throwable) : e;
        }
    }

    public static void logErrorMessage(String msg) {
        LicenseManagementUiActivator.log(msg, 4, null, false, false);
    }

    public static void logWarningMessage(String msg) {
        LicenseManagementUiActivator.log(msg, 2, null, false, false);
    }

    private static RuntimeException initRuntimeException(String message, Throwable throwable) {
        return new RuntimeException(message, throwable);
    }
}

