/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.ui.internal.dialogs;

import com.yakindu.licmgmt.ui.AbstractLicenseFeature;
import com.yakindu.licmgmt.ui.internal.model.TableItemData;
import com.yakindu.licmgmt.ui.internal.preferences.providers.LicenseDetailsContentProvider;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class LicenseDetailsDialog
extends Dialog {
    private TableItemData licenseTableItem;

    public LicenseDetailsDialog(Shell parentShell, TableItemData licenseTableItem) {
        super(parentShell);
        this.licenseTableItem = licenseTableItem;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(480, 350);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        ((GridLayout)parent.getLayout()).marginWidth = 10;
        ((GridLayout)parent.getLayout()).marginHeight = 10;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableColumnLayout);
        TableViewer detailsOfSelectedFeature = new TableViewer(composite, 67584);
        detailsOfSelectedFeature.getTable().setLinesVisible(true);
        detailsOfSelectedFeature.getTable().setHeaderVisible(false);
        if (this.licenseTableItem != null) {
            AbstractLicenseFeature selectedLicenseFeature = this.licenseTableItem.getLicenseFeature();
            parent.getShell().setText("License Details: " + selectedLicenseFeature.getProductName() + " " + selectedLicenseFeature.getFeatureName());
            detailsOfSelectedFeature.setContentProvider((IContentProvider)new LicenseDetailsContentProvider());
            TableViewerColumn keyColumn = this.initializeColumn(detailsOfSelectedFeature, e -> (String)e.getKey());
            TableViewerColumn valueColumn = this.initializeColumn(detailsOfSelectedFeature, e -> (String)e.getValue());
            tableColumnLayout.setColumnData((Widget)keyColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, true));
            tableColumnLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, true));
            detailsOfSelectedFeature.setInput((Object)this.licenseTableItem);
            keyColumn.getColumn().pack();
            valueColumn.getColumn().pack();
        }
        return composite;
    }

    private TableViewerColumn initializeColumn(TableViewer detailsOfSelectedFeature, final Function<Map.Entry<?, ?>, String> entryToString) {
        TableViewerColumn valueColumn = new TableViewerColumn(detailsOfSelectedFeature, 81920);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Map.Entry) {
                    return (String)entryToString.apply((Map.Entry)element);
                }
                throw new RuntimeException("unexpected, element should always be an instance of Entry");
            }
        });
        return valueColumn;
    }
}

