/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.generator.java.features;

import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.generator.core.extensions.StringHelper;
import com.yakindu.sct.generator.core.library.impl.CoreLibraryDefaultFeatureValueProvider;
import com.yakindu.sct.generator.java.GenmodelEntries;
import com.yakindu.sct.generator.java.features.IJavaFeatureConstants;
import com.yakindu.sct.model.sgen.FeatureParameterValue;
import com.yakindu.sct.model.sgen.FeatureType;
import com.yakindu.sct.model.sgen.FeatureTypeLibrary;
import com.yakindu.sct.model.sgen.GeneratorEntry;
import com.yakindu.sct.model.sgraph.Statechart;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class JavaFeatureValueProvider
extends CoreLibraryDefaultFeatureValueProvider {
    private static final String PACKAGE_NAME_REGEX = "([a-zA-Z_][a-zA-Z0-9_\\.]*)+[a-zA-Z_][a-zA-Z0-9_]*";
    private static final String TYPE_NAME_REGEX = "[a-zA-Z_$][a-zA-Z0-9_$]*";
    @Inject
    private GenmodelEntries entries;
    @Inject
    private StringHelper helper;

    public void setDefaultValue(FeatureType featureType, FeatureParameterValue parameterValue, EObject contextElement) {
        EObject element;
        super.setDefaultValue(featureType, parameterValue, contextElement);
        if (parameterValue.getParameter().getName().equals("basePackage")) {
            parameterValue.setValue("");
        } else if (parameterValue.getParameter().getName().equals("libraryPackage")) {
            parameterValue.setValue("com.yakindu.core");
        } else if (parameterValue.getParameter().getName().equals("typeName") && contextElement instanceof GeneratorEntry && (element = ((GeneratorEntry)contextElement).getElementRef()) instanceof NamedElement) {
            parameterValue.setValue(((NamedElement)element).getName());
        }
    }

    public boolean isProviderFor(FeatureTypeLibrary library) {
        return library.getName().equals("Java Generator");
    }

    public IStatus validateParameterValue(FeatureParameterValue value) {
        Matcher matcher;
        Pattern pattern;
        IStatus superResult = super.validateParameterValue(value);
        if (superResult != Status.OK_STATUS) {
            return superResult;
        }
        String name = value.getParameter().getName();
        if ("basePackage".equals(name) || "libraryPackage".equals(name)) {
            if (value.getStringValue().isEmpty()) {
                return Status.OK_STATUS;
            }
            if (!value.getStringValue().matches(PACKAGE_NAME_REGEX)) {
                return this.error("Invalid package name");
            }
            for (String keyword : Arrays.asList(IJavaFeatureConstants.JAVA_KEYWORDS)) {
                pattern = Pattern.compile("(?:^|\\.)" + keyword + "(?:$|\\.)");
                matcher = pattern.matcher(value.getStringValue());
                if (!matcher.find()) continue;
                return this.error("Java keyword '" + matcher.group() + "' is not allowed in package names.");
            }
        }
        if ("typeName".equals(name)) {
            if (!value.getStringValue().matches(TYPE_NAME_REGEX)) {
                return this.error("Invalid value");
            }
            for (String keyword : Arrays.asList(IJavaFeatureConstants.JAVA_KEYWORDS)) {
                pattern = Pattern.compile("^" + keyword + "$");
                matcher = pattern.matcher(value.getStringValue());
                if (!matcher.find()) continue;
                return this.error("Java keyword '" + matcher.group() + "' is not allowed as type name.");
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus validateGeneratorEntry(GeneratorEntry entry) {
        IStatus superResult = super.validateGeneratorEntry(entry);
        if (superResult != Status.OK_STATUS) {
            return superResult;
        }
        if (this.generatesToDefaultPackage(entry)) {
            return this.warning("Generation into default package is discouraged. Use a statechart namespace, or set the Naming.basePackage parameter.");
        }
        if (this.generatesLowerCaseType(entry)) {
            return this.warning("Generation of types starting with a lowercase letter is discouraged. Rename the statechart, or set the Naming.typeName parameter.");
        }
        return Status.OK_STATUS;
    }

    private boolean generatesLowerCaseType(GeneratorEntry entry) {
        Statechart statechart = this.entries.getStatechart(entry);
        if (statechart == null) {
            return false;
        }
        String sctName = statechart.getName();
        String typeName = this.entries.getTypeName(entry);
        return typeName == null && this.helper.isLowercase(sctName) || typeName != null && this.helper.isLowercase(typeName);
    }

    private boolean generatesToDefaultPackage(GeneratorEntry entry) {
        return this.entries.getBasePackage(entry).isEmpty();
    }
}

