/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.simulation.core.debugmodel;

import com.google.inject.Inject;
import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.model.sruntime.ExecutionContext;
import com.yakindu.sct.simulation.core.coverage.MeasureCalculator;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.coverage.MeasurementContext;
import com.yakindu.sct.simulation.core.debugmodel.SCTDebugElement;
import com.yakindu.sct.simulation.core.engine.IExecutionControl;
import com.yakindu.sct.simulation.core.engine.ISimulationEngine;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;

public class SCTDebugTarget
extends SCTDebugElement
implements IDebugTarget,
IStep {
    private ILaunch launch;
    private boolean primary = false;
    private final NamedElement element;
    private String context;
    protected ISimulationEngine engine;
    private IExecutionControl executionControl;
    private AdapterImpl updater;
    @Inject
    protected MeasurementContext measurementContext;
    protected MeasureCalculator measureCalculator = new MeasureCalculator();

    public SCTDebugTarget(ILaunch launch, NamedElement element, ISimulationEngine engine) throws CoreException {
        super(null, SCTDebugTarget.platformString(element));
        this.launch = launch;
        this.element = element;
        this.engine = engine;
    }

    public SCTDebugTarget(ILaunch launch, NamedElement element, String context, ISimulationEngine engine) throws CoreException {
        this(launch, element, engine);
        this.context = context;
    }

    protected static String platformString(NamedElement element) {
        return element.eResource() != null ? element.eResource().getURI().toPlatformString(true) : "";
    }

    public void init() {
        this.executionControl = this.engine.getExecutionControl();
        this.executionControl.init();
        this.executionControl.modeChanged().subscribe(n -> this.fireChangeEvent(512));
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
    }

    public void start() {
        this.executionControl.start();
        this.fireChangeEvent(512);
    }

    public IProcess getProcess() {
        return null;
    }

    public synchronized IThread[] getThreads() throws DebugException {
        return new IThread[0];
    }

    public boolean hasThreads() throws DebugException {
        return false;
    }

    public String getName() throws DebugException {
        if (this.context != null) {
            return this.context + " : " + this.element.getName();
        }
        return this.element.getName();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().startsWith("com.yakindu.sct.simulation");
    }

    public boolean canTerminate() {
        return this.executionControl.canTerminate();
    }

    public boolean isTerminated() {
        return this.executionControl.isTerminated();
    }

    public void terminate() throws DebugException {
        this.executionControl.terminate();
        if (this.engine.getExecutionContext() != null) {
            this.engine.getExecutionContext().eAdapters().remove((Object)this.updater);
        }
        this.fireEvent(new DebugEvent((Object)this.getDebugTarget(), 8));
    }

    public boolean canResume() {
        return this.executionControl.canResume();
    }

    public boolean canSuspend() {
        return this.executionControl.canSuspend();
    }

    public boolean isSuspended() {
        return this.executionControl.isSuspended();
    }

    public void resume() throws DebugException {
        new Thread(() -> {
            this.executionControl.resume();
            this.fireEvent(new DebugEvent((Object)this, 1));
            this.fireChangeEvent(512);
        }, "Resume Execution").start();
    }

    public void suspend() throws DebugException {
        new Thread(() -> {
            this.executionControl.suspend();
            this.fireEvent(new DebugEvent((Object)this, 2));
            this.fireChangeEvent(512);
        }, "Suspend Execution").start();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISimulationEngine.class) {
            return this.engine;
        }
        if (adapter == IExecutionControl.class) {
            return this.engine.getExecutionControl();
        }
        if (adapter == ExecutionContext.class) {
            return this.engine.getExecutionContext();
        }
        if (adapter == EObject.class) {
            return this.element;
        }
        return super.getAdapter(adapter);
    }

    public boolean canStepOver() {
        return this.executionControl.canStepForward();
    }

    public void stepOver() {
        new Thread(() -> {
            this.executionControl.stepForward();
            this.fireEvent(new DebugEvent((Object)this.getDebugTarget(), 2));
        }, "StepOver Execution").start();
    }

    public boolean isStepping() {
        return this.executionControl.isStepping();
    }

    public ISimulationEngine getSimulationEngine() {
        return this.engine;
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public void stepInto() throws DebugException {
    }

    public void stepReturn() throws DebugException {
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public Measurement getMeasurement() {
        return this.measurementContext.getRootMeasurement();
    }

    public MeasurementContext getMeasurementContext() {
        return this.measurementContext;
    }
}

