/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.licmgmt.internal;

import com.xformation.lmx.Lmx;
import com.xformation.lmx.LmxException;
import com.xformation.lmx.LmxFeatureInfo;
import com.xformation.lmx.LmxHostid;
import com.xformation.lmx.LmxHostidType;
import com.xformation.lmx.LmxLicenseInfo;
import com.xformation.lmx.LmxLicenseType;
import com.xformation.lmx.LmxSettings;
import com.xformation.lmx.LmxStatus;
import com.yakindu.licmgmt.ILicenseChangedListener;
import com.yakindu.licmgmt.ILicenseManager;
import com.yakindu.licmgmt.ILicenseService;
import com.yakindu.licmgmt.LicenseException;
import com.yakindu.licmgmt.LicenseStatus;
import com.yakindu.licmgmt.ServerSettings;
import com.yakindu.licmgmt.internal.GeneralExceptionHelper;
import com.yakindu.licmgmt.internal.LicenseExceptionHelper;
import com.yakindu.licmgmt.internal.LicenseService;
import com.yakindu.licmgmt.internal.LicenseSettings;
import com.yakindu.licmgmt.internal.LicenseTaskFactory;
import com.yakindu.licmgmt.internal.LicenseVersion;
import com.yakindu.licmgmt.internal.LoggingHelper;
import com.yakindu.licmgmt.internal.custom.CustomLicenseHelper;
import com.yakindu.licmgmt.internal.events.LicenseErrorEvent;
import com.yakindu.licmgmt.internal.events.LicenseEvent;
import com.yakindu.licmgmt.internal.events.LicenseInfoEvent;
import com.yakindu.licmgmt.internal.events.LicenseWarningEvent;
import com.yakindu.licmgmt.internal.utils.DateUtils;
import com.yakindu.licmgmt.internal.utils.PathUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class LicenseManager
implements ILicenseManager {
    private static final int YLM_DEFAULT_TRIAL_DAYS = 30;
    private static final String LMX_LICINFO_TIMEOUT_SEC = "2";
    private static final String LMX_CHECKOUT_TIMEOUT_SEC = "4";
    private static final String LMX_HEARTBEAT_TIMEOUT_SEC = "120";
    private static final String EARLY_CHECKIN_BORROWED_LICENSE = "-1";
    private static final String OPT_AUTO_RENEWABLE_BORROWING = "AUTO_RENEWABLE_BORROWING";
    private static final String LMX_BORROW = "LMX_BORROW";
    private static final String LMX_BORROW_FORCE_RETURN = "LMX_BORROW_FORCE_RETURN";
    private static final String LMX_CONNECTION_TIMEOUT = "LMX_CONNECTION_TIMEOUT";
    private final LicenseService service = (LicenseService)ILicenseService.INSTANCE;
    private final LicenseSettings settings = (LicenseSettings)this.service.getSettings();
    private final CustomLicenseHelper customLicenseHelper = new CustomLicenseHelper();
    private boolean checkedOut = false;
    private LicenseVersion licenseVersion;
    private Lmx lmx;
    private LicenseException currentError;
    private List<Timer> timers = new LinkedList<Timer>();
    private boolean isEnabled = true;
    private boolean acquireRequested = false;
    private boolean expiresSoonReported = false;
    private final List<String> defaultLicensePaths;
    private final List<String> additionalLicensePaths;
    private String serverPath;
    private final String featureId;
    private final String featureVersion;
    private final Collection<ILicenseChangedListener> licenseStateChangeListeners = new CopyOnWriteArrayList<ILicenseChangedListener>();
    private StringBuilder licenseErrorMessageBuilder = new StringBuilder();
    private LicenseTaskFactory licenseTaskFactory;

    private List<String> getLicensePaths() {
        return PathUtils.getLicensePaths(this.defaultLicensePaths, this.additionalLicensePaths, this.serverPath);
    }

    public void checkForUpdatedLicensePaths(List<String> additionalPaths) throws LicenseException {
        List<String> newLicensePaths;
        List<String> oldLicensePaths;
        List<String> newDefaultPaths = this.getDefaultPaths();
        List<String> newAdditionalPaths = PathUtils.appendAdditionalPathsWithoutDuplicates(new ArrayList<String>(this.additionalLicensePaths), additionalPaths);
        String newServerPath = this.getServerPath();
        if (!(this.additionalLicensePaths.equals(newAdditionalPaths) && Objects.equals(this.serverPath, newServerPath) && newDefaultPaths.equals(this.defaultLicensePaths) || (oldLicensePaths = this.getLicensePaths()).equals(newLicensePaths = PathUtils.getLicensePaths(newDefaultPaths, newAdditionalPaths, newServerPath)))) {
            this.serverPath = newServerPath;
            this.defaultLicensePaths.clear();
            this.defaultLicensePaths.addAll(newDefaultPaths);
            this.additionalLicensePaths.clear();
            this.additionalLicensePaths.addAll(newAdditionalPaths);
            this.initLmxLicensePaths();
            LoggingHelper.info("License paths for %s updated from %s to %s.", this.featureId, oldLicensePaths, newLicensePaths);
        }
    }

    protected String getServerPath() {
        return PathUtils.getServerPath(this.getSettings().getServerSettings());
    }

    protected List<String> getDefaultPaths() {
        return PathUtils.getDefaultPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseManager(String featureId, String featureVersion, List<String> additionalLicenseFilePaths) throws LicenseException {
        if (featureId == null) {
            throw new IllegalArgumentException("Feature spec code must not be null.");
        }
        if (featureVersion == null) {
            throw new IllegalArgumentException("Feature spec version must not be null.");
        }
        ServerSettings serverSettings = this.getSettings().getServerSettings();
        if (serverSettings.isEnabled()) {
            this.serverPath = PathUtils.getServerPath(serverSettings);
        }
        this.defaultLicensePaths = this.getDefaultPaths();
        this.additionalLicensePaths = additionalLicenseFilePaths == null ? Collections.emptyList() : new ArrayList<String>(additionalLicenseFilePaths);
        this.featureId = featureId;
        this.featureVersion = featureVersion;
        GeneralExceptionHelper.verifyLicensePaths(this.additionalLicensePaths);
        LicenseExceptionHelper.verifyFeatureId(featureId);
        LicenseExceptionHelper.verifyFeatureVersion(featureVersion);
        try {
            Class<LicenseManager> clazz = LicenseManager.class;
            synchronized (LicenseManager.class) {
                this.doInitLmx();
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            String osArch;
            if (LicenseService.DEBUG) {
                System.out.println("Maybe you missed to add VM argument like: -Djava.library.path=${project_loc:com.yakindu.licmgmt.lmx.win32.win32.x86_64}");
            }
            String msg = (osArch = System.getProperty("os.arch")) == null || osArch.contains("64") ? "License manager cannot be created because LM-X platform-specific library cannot be loaded." : "License manager cannot be created because LM-X platform-specific library cannot be loaded. Please try to use a 64bit JVM.";
            LicenseExceptionHelper.throwLicenseException(String.valueOf(msg) + " " + e.getMessage());
        }
        catch (LmxException e) {
            throw this.handleLmxException("Failed to initialize license manager", e);
        }
        {
            this.initLmxLicensePaths();
            this.initLmxAutoTrialAndCheckClientHostIds();
            this.licenseVersion = LicenseVersion.createLicenseVersion(featureVersion);
            return;
        }
    }

    protected void doInitLmx() throws LmxException {
        this.lmx = new Lmx();
        this.lmx.init();
        this.lmx.setCustomHostidCallback(hostIds -> this.customLicenseHelper.addHostIds((List<LmxHostid>)hostIds, this.settings));
    }

    protected void clearStatus() {
        this.clearLicenseMessages();
        this.currentError = null;
    }

    protected void setCurrentError(LicenseException error) {
        this.currentError = error;
    }

    public String getFullErrorMessage() {
        return this.currentError != null ? this.currentError.getErrorMessage() : "";
    }

    public String getSimpleErrorMessage() {
        return this.currentError != null ? this.currentError.getSimpleErrorMessage() : "";
    }

    public LmxStatus getLmxStatus() {
        return this.currentError == null ? LmxStatus.LMX_SUCCESS : this.currentError.getStatus();
    }

    @Override
    public String getStatusMessage() {
        if (this.currentError == null) {
            return this.getLicenseStatus().text;
        }
        return this.licenseErrorMessageBuilder.toString();
    }

    @Override
    public LicenseStatus getLicenseStatus() {
        return LicenseStatus.create(this);
    }

    public void setLicenseErrorMessage(String licenseErrorMessage) {
        String msgToAdd = licenseErrorMessage;
        if (msgToAdd != null && !this.licenseErrorMessageBuilder.toString().contains(msgToAdd)) {
            int length = this.licenseErrorMessageBuilder.length();
            if (length > 0) {
                msgToAdd = "\n" + msgToAdd;
            }
            this.licenseErrorMessageBuilder.append(msgToAdd);
        }
    }

    public void clearLicenseMessages() {
        this.licenseErrorMessageBuilder = new StringBuilder();
    }

    @Override
    public String getFeatureId() {
        return this.featureId;
    }

    @Override
    public String getFeatureVersion() {
        return this.featureVersion;
    }

    public List<String> getAdditionalLicensePaths() {
        return Collections.unmodifiableList(this.additionalLicensePaths);
    }

    public void setEnabled(boolean isEnabled) throws IllegalStateException {
        if (!isEnabled && this.isCheckedOut()) {
            throw new IllegalStateException("License is already checked-out, disabling is not possible!");
        }
        this.isEnabled = isEnabled;
        if (this.isAcquireRequested() && isEnabled) {
            LoggingHelper.info("License feature %s is now enabled and was acquired before while it was disabled; re-attempting to acquire it.", this.featureId);
            LmxStatus.LMX_SUCCESS.equals((Object)this.acquire());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    void shutdown() {
        this.stopAndRemoveTimerTasks();
        this.getSettings().clear();
    }

    void stopAndRemoveTimerTasks() {
        for (Timer timer : Collections.unmodifiableList(this.timers)) {
            timer.cancel();
            timer.purge();
            this.timers.remove(timer);
            Object var1_2 = null;
        }
    }

    public boolean isDongleLicense() {
        LmxFeatureInfo featureInfo = this.getFeatureInfo();
        if (featureInfo != null) {
            for (LmxHostid host : featureInfo.getClientLicenseHostid()) {
                if (!LmxHostidType.LMX_HOSTID_DONGLE_HASPHL.equals((Object)host.getHostidType())) continue;
                return true;
            }
        }
        return false;
    }

    protected LmxStatus loadLicense() {
        try {
            if (this.getSettings().isAutoBorrowingEnabled()) {
                this.setEnv(LMX_BORROW, "1");
            } else {
                this.setEnv(LMX_BORROW, "0");
            }
            this.checkoutLicense(true);
        }
        catch (LicenseException licenseException) {
            // empty catch block
        }
        return this.getLmxStatus();
    }

    protected LicenseSettings getSettings() {
        return this.settings;
    }

    @Override
    public LmxStatus acquire() {
        this.acquireRequested = true;
        if (!this.isCheckedOut()) {
            return this.loadLicense();
        }
        if (this.getExpireTime() == -1) {
            return this.updateLicense(false);
        }
        return LmxStatus.LMX_SUCCESS;
    }

    @Override
    public LmxStatus release() {
        try {
            if (this.isBorrowed()) {
                String errorMsg = String.format("License %s is borrowed, please return it first.", this.featureId);
                throw this.handleErrorStatus(errorMsg, LmxStatus.LMX_BORROW_RETURN_ERROR);
            }
            this.releaseLicense(true);
        }
        catch (LicenseException e) {
            return e.getStatus();
        }
        this.acquireRequested = false;
        return LmxStatus.LMX_SUCCESS;
    }

    protected void releaseLicense(boolean notifyListeners) throws LicenseException {
        if (this.isCheckedOut()) {
            this.doCheckin(notifyListeners);
        }
    }

    public LmxStatus updateLicense(boolean notifyListeners) {
        boolean wasCheckedOut = this.isCheckedOut();
        try {
            try {
                this.releaseLicense(notifyListeners);
                this.checkoutLicense(notifyListeners);
            }
            catch (LicenseException e) {
                LmxStatus lmxStatus = e.getStatus();
                if (wasCheckedOut && !this.isCheckedOut()) {
                    this.notifyLicenseChanged(ILicenseChangedListener.LicenseNotificationEvent.LICENSE_NOT_AVAILABLE);
                }
                return lmxStatus;
            }
        }
        finally {
            if (wasCheckedOut && !this.isCheckedOut()) {
                this.notifyLicenseChanged(ILicenseChangedListener.LicenseNotificationEvent.LICENSE_NOT_AVAILABLE);
            }
        }
        return LmxStatus.LMX_SUCCESS;
    }

    @Override
    public int getExpireTime() {
        if (this.checkedOut) {
            return this.lmx.getExpireTime(this.featureId);
        }
        if (this.currentError != null && this.currentError.getStatus() == LmxStatus.LMX_TOO_LATE_DATE) {
            return -1;
        }
        return -3;
    }

    public long getFeatureExpireTime(LmxFeatureInfo featureInfo) {
        LmxLicenseType licType;
        LmxLicenseType lmxLicenseType = licType = featureInfo == null ? null : featureInfo.getLicenseType();
        if (this.checkedOut && (licType == LmxLicenseType.LMX_TYPE_BORROW || licType == LmxLicenseType.LMX_TYPE_GRACE || licType == LmxLicenseType.LMX_TYPE_TRIAL)) {
            String endDate = featureInfo.getEndDate();
            if (endDate == null || endDate.isEmpty()) {
                return -2L;
            }
            try {
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                LocalDateTime dateTime = LocalDateTime.from(format.parse(String.valueOf(endDate) + " 00:00"));
                return LocalDateTime.now().until(dateTime, ChronoUnit.HOURS) + 24L;
            }
            catch (Exception e) {
                LoggingHelper.warn("Failed to calculate expire time from end date '%s' (expected format: YYYY-MM-DD) for feature: %s", endDate, featureInfo.getFeatureName());
            }
        }
        return this.getExpireTime();
    }

    @Override
    public boolean isBorrowed() {
        LmxFeatureInfo featureInfo = this.getFeatureInfo();
        return featureInfo != null && featureInfo.getLicenseType() == LmxLicenseType.LMX_TYPE_BORROW;
    }

    @Override
    public LmxStatus unborrowAndRelease() {
        try {
            this.setEnv(LMX_BORROW, EARLY_CHECKIN_BORROWED_LICENSE);
            this.releaseLicense(true);
            this.setEnv(LMX_BORROW, "0");
            return LmxStatus.LMX_SUCCESS;
        }
        catch (LicenseException e) {
            return e.getStatus();
        }
    }

    @Override
    public LmxStatus unborrow() {
        try {
            this.setEnv(LMX_BORROW, EARLY_CHECKIN_BORROWED_LICENSE);
            this.releaseLicense(false);
            this.checkoutLicense(false);
            this.setEnv(LMX_BORROW, "0");
            return LmxStatus.LMX_SUCCESS;
        }
        catch (LicenseException e) {
            return e.getStatus();
        }
    }

    @Override
    public LmxStatus borrow(int actualBorrowingHours) {
        if (actualBorrowingHours < 1) {
            throw new IllegalArgumentException("Hours to borrow a license cannot be less than 1");
        }
        boolean wasCheckedOut = this.isCheckedOut();
        try {
            if (wasCheckedOut) {
                LmxFeatureInfo featureInfo = this.getFeatureInfo();
                int maxBorrowingHours = featureInfo.getBorrowHours();
                if (maxBorrowingHours < actualBorrowingHours) {
                    throw new IllegalArgumentException(String.format("This license cannot be borrowed for %d hours, because max is %d hours", actualBorrowingHours, maxBorrowingHours));
                }
                long expireTime = this.getFeatureExpireTime(featureInfo) - 24L;
                if (expireTime > 0L && (long)actualBorrowingHours > expireTime) {
                    throw new IllegalArgumentException(String.format("This license cannot be borrowed for %d hours, because license already expires in %d hours", actualBorrowingHours, expireTime));
                }
                this.releaseLicense(false);
            }
            this.setEnv(LMX_BORROW, String.valueOf(actualBorrowingHours));
            LoggingHelper.info("License '%s' borrowed for %d hours", this.featureId, actualBorrowingHours);
            this.checkoutLicense(!wasCheckedOut);
            this.setEnv(LMX_BORROW, "0");
            return LmxStatus.LMX_SUCCESS;
        }
        catch (LicenseException e) {
            return e.getStatus();
        }
    }

    private void initLmxAutoTrialAndCheckClientHostIds() throws LicenseException {
        int trialDays = this.getSettings().isTrialEnabled() ? 30 : 0;
        int checkClientHostIds = this.getSettings().isCheckClientHostIds() ? 1 : 0;
        this.setOption(LmxSettings.LMX_OPT_TRIAL_DAYS, trialDays);
        this.setOption(LmxSettings.LMX_OPT_CLIENT_HOSTIDS_TO_SERVER, checkClientHostIds);
        this.setOption(LmxSettings.LMX_OPT_TRIAL_VIRTUAL_MACHINE, 1);
    }

    private void initLmxLicensePaths() throws LicenseException {
        List<String> allPaths = this.getLicensePaths();
        String paths = allPaths.stream().collect(Collectors.joining(File.pathSeparator));
        this.setOption(LmxSettings.LMX_OPT_LICENSE_PATH, paths);
    }

    protected void checkoutLicense(boolean notifyListeners) throws LicenseException {
        if (!this.isEnabled()) {
            String errorMsg = String.format("The license feature '%s' is disabled and therefore can't be checked out", this.getFeatureId());
            throw this.handleErrorStatus(errorMsg, LmxStatus.LMX_VENDOR_DENY);
        }
        boolean doNotifyListeners = notifyListeners && !this.getSettings().isAutoBorrowingEnabled();
        this.doCheckout(doNotifyListeners);
        this.checkAutoRenewableBorrowing(notifyListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCheckout(boolean notifyListeners) throws LicenseException {
        if (this.isCheckedOut()) {
            LoggingHelper.debug("License feature '%s' with version %d.%d is already acquired. Skipping checkout.", this.featureId, this.licenseVersion.getMajor(), this.licenseVersion.getMinor());
            return;
        }
        LoggingHelper.debug("Starting LMX license checkout with options: " + this.featureId + ", " + this.licenseVersion.getMajor() + ", " + this.licenseVersion.getMinor() + ", 1", new Object[0]);
        Class<LicenseManager> clazz = LicenseManager.class;
        synchronized (LicenseManager.class) {
            try {
                this.doLmxCheckout();
                this.clearStatus();
                this.checkForAlreadyExpiredTrialLicense();
            }
            catch (ExpiredTrialException e) {
                try {
                    this.lmx.checkin(this.featureId, 0);
                }
                catch (LmxException lmxException) {
                    // empty catch block
                }
                LicenseException exception = this.handleLmxException("The trial license is expired", new LmxException(LmxStatus.LMX_TOO_LATE_DATE, 0L), () -> LicenseErrorEvent.createForExpiredFeature(this));
                this.clearLicenseMessages();
                this.setLicenseErrorMessage("The trial license is expired");
                throw exception;
            }
            catch (LmxException e) {
                switch (e.getErrorCode()) {
                    case LMX_SOFTLIMIT: {
                        this.handleErrorStatus("Soft limit exceeded -> LICENSE OVERUSE detected.", e.getErrorCode());
                        this.service.postEvent(LicenseWarningEvent.create("License Overuse detected for '" + this.featureId + "'!", "Request exceeds the number of purchased licenses available. Please consider to buy additional licenses."));
                        break;
                    }
                    case LMX_SINGLE_LOCK: {
                        throw this.handleErrorStatus("License server limitation on number of borrowed features exceeded", e.getErrorCode());
                    }
                    default: {
                        throw this.handleLmxException("Failed to check out license", e, () -> LicenseErrorEvent.createForFailedCheckout(this));
                    }
                }
            }
            LoggingHelper.debug("LMX license checkout complete.", new Object[0]);
            this.setConnectionTimeout(LMX_HEARTBEAT_TIMEOUT_SEC);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.startTimerTasks();
            LmxFeatureInfo featureInfo = this.getFeatureInfo();
            String msg = String.format("License checkout performed for %s %d.%d (%s), location: %s, expire time: %s%s", this.featureId, featureInfo.getMajorVer(), featureInfo.getMinorVer(), featureInfo.getLicenseType().name(), featureInfo.getPath(), PathUtils.nullOrEmpty(featureInfo.getActualExpireTime()) ? "<none>" : featureInfo.getActualExpireTime(), PathUtils.nullOrEmpty(featureInfo.getMaintenanceEndDate()) ? "" : ", maintenance end: " + featureInfo.getMaintenanceEndDate());
            LoggingHelper.info(msg, new Object[0]);
            boolean notifyNeeded = this.setCheckedOut(true);
            if (notifyNeeded && notifyListeners) {
                this.notifyLicenseChanged(ILicenseChangedListener.LicenseNotificationEvent.LICENSE_AVAILABLE);
            }
            this.service.postEvent(LicenseInfoEvent.createForSuccessfulCheckout(msg, this));
            if (!this.expiresSoonReported && this.willExpireSoon()) {
                this.service.postEvent(LicenseWarningEvent.createForSoonExpiringLicense(this));
                this.expiresSoonReported = true;
            }
            return;
        }
    }

    protected void doLmxCheckout() throws LmxException {
        try {
            this.setConnectionTimeout(LMX_CHECKOUT_TIMEOUT_SEC);
        }
        catch (LicenseException licenseException) {
            // empty catch block
        }
        this.reportLongDurationInDebugger(() -> {
            this.lmx.checkout(this.featureId, this.licenseVersion.getMajor(), this.licenseVersion.getMinor(), 1);
            return null;
        }, "doLmxCheckout()");
    }

    protected void checkForAlreadyExpiredTrialLicense() throws ExpiredTrialException {
        LmxFeatureInfo myFeatureInfo = this.getFeatureInfo();
        if (myFeatureInfo != null && myFeatureInfo.getLicenseType() == LmxLicenseType.LMX_TYPE_TRIAL) {
            long start = System.currentTimeMillis();
            try {
                for (LmxLicenseInfo licenseInfo : this.getLicenseInfos()) {
                    for (LmxFeatureInfo otherFeatureInfo : licenseInfo.getFeatures()) {
                        if (!this.isAnotherExpiredTrial(myFeatureInfo, otherFeatureInfo)) continue;
                        LoggingHelper.info("Existing trial license found for feature %s (%d.%d) which is already expired (%d.%d): %s", myFeatureInfo.getFeatureName(), myFeatureInfo.getMajorVer(), myFeatureInfo.getMinorVer(), otherFeatureInfo.getMajorVer(), otherFeatureInfo.getMinorVer(), otherFeatureInfo.getActualExpireTime());
                        throw new ExpiredTrialException();
                    }
                }
            }
            finally {
                long duration;
                if (LicenseService.DEBUG && (duration = System.currentTimeMillis() - start) > 1000L) {
                    System.err.println("LicenseManager.checkForAlreadyExpiredTrialLicense() took " + duration + "ms. This is too long, we should re-investigate how to optimize this code.");
                }
            }
        }
    }

    protected boolean isAnotherExpiredTrial(LmxFeatureInfo myFeatureInfo, LmxFeatureInfo otherFeatureInfo) {
        if (otherFeatureInfo == null || myFeatureInfo == otherFeatureInfo) {
            return false;
        }
        if (otherFeatureInfo.getLicenseType() != LmxLicenseType.LMX_TYPE_TRIAL) {
            return false;
        }
        if (!myFeatureInfo.getFeatureName().equals(otherFeatureInfo.getFeatureName())) {
            return false;
        }
        Date expirationDate = DateUtils.convertActualExpireTime(otherFeatureInfo.getActualExpireTime());
        if (expirationDate == null) {
            return false;
        }
        Date now = new Date();
        return !now.before(expirationDate);
    }

    protected boolean willExpireSoon() {
        int expireTime = this.getExpireTime();
        if (expireTime == -2) {
            return false;
        }
        return this.getSettings().getDaysToNotifySoonExpiringLicenses() * 24 >= expireTime;
    }

    private void setConnectionTimeout(String seconds) throws LicenseException {
        this.setEnv(LMX_CONNECTION_TIMEOUT, seconds);
    }

    protected void startTimerTasks() throws LicenseException {
        LmxFeatureInfo featureInfo = this.getFeatureInfo();
        if (LmxLicenseType.LMX_TYPE_NETWORK.equals((Object)featureInfo.getLicenseType())) {
            this.timers.add(this.getLicenseTaskFactory().createHeartbeatTask(this.lmx, this.featureId, e -> this.handleTimerFailure((LmxException)((Object)e), "Unable to connect to license server (heartbeat failed), performing a license checkin of: %s.%s\n", () -> LicenseErrorEvent.createForLastFailedHeartbeat(this))));
        }
        for (LmxHostid host : featureInfo.getClientLicenseHostid()) {
            if (!LmxHostidType.LMX_HOSTID_DONGLE_HASPHL.equals((Object)host.getHostidType())) continue;
            this.timers.add(this.getLicenseTaskFactory().createDongleTask(this.lmx, host.getValue(), this.featureId, e -> this.handleTimerFailure((LmxException)((Object)e), "Dongle failure, performing a license checkin of: %s.%s\n", () -> LicenseErrorEvent.createForFailedDongle(this))));
        }
        int expireTimeInHours = this.getExpireTime();
        if (expireTimeInHours >= 0) {
            long delay = expireTimeInHours == 0 ? TimeUnit.MINUTES.toMillis(1L) : TimeUnit.HOURS.toMillis(expireTimeInHours);
            this.timers.add(this.getLicenseTaskFactory().createExpirationTask(this.lmx, this.featureId, delay, e -> this.handleTimerFailure((LmxException)((Object)e), "License expired, performing a license checkin of: %s.%s\n", () -> LicenseErrorEvent.createForExpiredFeature(this))));
        }
    }

    private LicenseTaskFactory getLicenseTaskFactory() {
        if (this.licenseTaskFactory == null) {
            this.licenseTaskFactory = this.createLicenseTaskFactory();
        }
        return this.licenseTaskFactory;
    }

    protected LicenseTaskFactory createLicenseTaskFactory() {
        return new LicenseTaskFactory();
    }

    private void handleTimerFailure(LmxException e, String errorMsg, Supplier<LicenseEvent> event) {
        if (!this.isCheckedOut()) {
            return;
        }
        String msg = String.format(errorMsg, this.featureId, e.getErrorStrSimple());
        try {
            LoggingHelper.trace(msg, new Object[0]);
            this.doCheckin(true);
        }
        catch (LicenseException licenseException) {
            // empty catch block
        }
        this.handleLmxException(msg, e, event);
    }

    protected void checkAutoRenewableBorrowing(boolean notifyListeners) throws LicenseException {
        LmxFeatureInfo featureInfo = this.getFeatureInfo();
        if (!OPT_AUTO_RENEWABLE_BORROWING.equals(featureInfo.getOptions())) {
            return;
        }
        if (this.getSettings().isAutoBorrowingEnabled()) {
            if (this.isServerReachable()) {
                long expireHours;
                int maxBorrowHours = featureInfo != null ? featureInfo.getBorrowHours() : 0;
                long expireTime = this.getFeatureExpireTime(featureInfo);
                long l = expireHours = expireTime >= 0L ? expireTime - 24L : Integer.MAX_VALUE;
                if (expireHours > 0L) {
                    this.setEnv(LMX_BORROW, EARLY_CHECKIN_BORROWED_LICENSE);
                    this.setEnv(LMX_BORROW_FORCE_RETURN, "1");
                    this.doCheckin(false);
                    this.setEnv(LMX_BORROW, String.valueOf(Math.min((long)maxBorrowHours, expireHours)));
                    this.setEnv(LMX_BORROW_FORCE_RETURN, "0");
                    this.doCheckout(false);
                    this.setEnv(LMX_BORROW, "0");
                }
            }
        } else {
            try {
                this.setEnv(LMX_BORROW, EARLY_CHECKIN_BORROWED_LICENSE);
                this.setEnv(LMX_BORROW_FORCE_RETURN, "1");
                this.releaseLicense(false);
            }
            finally {
                this.setEnv(LMX_BORROW, "0");
                this.setEnv(LMX_BORROW_FORCE_RETURN, "0");
            }
            this.doCheckout(notifyListeners);
            if (OPT_AUTO_RENEWABLE_BORROWING.equals(featureInfo.getOptions())) {
                this.releaseLicense(notifyListeners);
                throw this.handleErrorStatus(String.format("License for feature '%s' requires 'auto-borrowing' to be enabled", this.featureId), LmxStatus.LMX_BORROW_NOT_ENABLED);
            }
            return;
        }
    }

    protected boolean isServerReachable() {
        ServerSettings serverSettings = this.getSettings().getServerSettings();
        if (!serverSettings.isEnabled()) {
            return false;
        }
        for (String host : serverSettings.getHosts()) {
            block14: {
                int port = Integer.parseInt(serverSettings.getPort());
                InetSocketAddress socketAddress = new InetSocketAddress(host, port);
                Throwable throwable = null;
                Object var7_9 = null;
                Socket socket = new Socket();
                try {
                    socket.connect(socketAddress, 2000);
                    LoggingHelper.info("License server (%s:%d) reachability check successful for feature %s.", host, port, this.featureId);
                    if (socket == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                socket.close();
            }
            return true;
        }
        LoggingHelper.info("License server(s) not reachable for feature %s: %s (port %s)", this.featureId, serverSettings.getHost(), serverSettings.getPort());
        return false;
    }

    protected void doCheckin(boolean notifyListeners) throws LicenseException {
        for (Timer timer : this.timers) {
            timer.cancel();
        }
        this.timers.clear();
        try {
            this.lmx.checkin(this.featureId, 0);
            this.clearStatus();
        }
        catch (LmxException e) {
            boolean checkinSuccessful = this.getFeatureInfo() == null;
            LicenseEvent checkinFailureEvent = checkinSuccessful ? LicenseWarningEvent.createForSuccessfulCheckin(this) : LicenseWarningEvent.createForFailedCheckin(this);
            throw this.handleLmxException("Failed to check in license", e, () -> checkinFailureEvent);
        }
        LoggingHelper.info("License checked in for feature %s", this.featureId);
        boolean notifyNeeded = this.setCheckedOut(false);
        if (notifyNeeded && notifyListeners) {
            this.notifyLicenseChanged(ILicenseChangedListener.LicenseNotificationEvent.LICENSE_NOT_AVAILABLE);
        }
        this.service.postEvent(LicenseInfoEvent.createForSuccessfulCheckin(this));
    }

    private boolean setCheckedOut(boolean checkedOut) {
        boolean changed = this.checkedOut ^ checkedOut;
        this.checkedOut = checkedOut;
        return changed;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public boolean isAcquireRequested() {
        return this.acquireRequested;
    }

    @Override
    public boolean isTrial() {
        LmxFeatureInfo featureInfo = this.getFeatureInfo();
        return featureInfo != null && featureInfo.getLicenseType() == LmxLicenseType.LMX_TYPE_TRIAL;
    }

    protected void setEnv(String name, String value) throws LicenseException {
        this.checkArgumentsNotNull(name, value);
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name of the environment variable cannot be empty!");
        }
        try {
            this.lmx.putEnv(String.valueOf(name) + "=" + value);
            LoggingHelper.debug("Environment variable set: '" + name + "'='" + value + "'", new Object[0]);
        }
        catch (LmxException e) {
            String errorMessage = String.format("Failed to set LM-X specific environment variable '%s' to '%s'", name, value);
            throw this.handleLmxException(errorMessage, e);
        }
    }

    protected void setOption(LmxSettings setting, String value) throws LicenseException {
        this.checkArgumentsNotNull(setting, value);
        try {
            this.lmx.setOption(setting, value);
        }
        catch (LmxException e) {
            String errorMessage = String.format("Failed to set LM-X specific option '%s' to '%s'", setting, value);
            throw this.handleLmxException(errorMessage, e);
        }
        LoggingHelper.debug("LMX option '%s' set to '%s'", setting, value);
    }

    private void setOption(LmxSettings setting, int value) throws LicenseException {
        this.checkArgumentsNotNull(setting, value);
        try {
            this.lmx.setOption(setting, value);
        }
        catch (LmxException e) {
            String errorMessage = String.format("Failed to set LM-X specific option '%s' to '%s'", setting, value);
            throw this.handleLmxException(errorMessage, e);
        }
        LoggingHelper.debug("LMX option '%s' set to: '%d'", setting, value);
    }

    private void checkArgumentsNotNull(Object name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("Arguments cannot be null!");
        }
    }

    @Override
    public LmxFeatureInfo getFeatureInfo() {
        try {
            return this.reportLongDurationInDebugger(() -> this.lmx.getFeatureInfo(this.featureId), "getFeatureInfo()");
        }
        catch (LmxException lmxException) {
            return null;
        }
    }

    @Override
    public List<LmxLicenseInfo> getLicenseInfos() {
        try {
            this.setConnectionTimeout(LMX_LICINFO_TIMEOUT_SEC);
        }
        catch (LicenseException licenseException) {
            // empty catch block
        }
        try {
            return this.reportLongDurationInDebugger(() -> this.lmx.getLicenseInfo(), "getLicenseInfos()");
        }
        catch (LmxException lmxException) {
            LoggingHelper.warn("Error when getting LicenseInfos", lmxException, new Object[0]);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean removeListener(ILicenseChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        return this.licenseStateChangeListeners.remove(listener);
    }

    @Override
    public boolean addListener(ILicenseChangedListener listener) {
        return this.licenseStateChangeListeners.add(listener);
    }

    protected void notifyLicenseChanged(ILicenseChangedListener.LicenseNotificationEvent event) {
        for (ILicenseChangedListener listener : this.licenseStateChangeListeners) {
            this.notifyListener(listener, event);
        }
    }

    private void notifyListener(ILicenseChangedListener listener, ILicenseChangedListener.LicenseNotificationEvent event) {
        try {
            listener.notify(event, this);
        }
        catch (Exception e) {
            LoggingHelper.error("An exception occurred while notifying listener '" + listener + "' about event " + (Object)((Object)event) + " for: " + this, e, new Object[0]);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [featureId=" + this.featureId + ", featureVersion=" + this.featureVersion + ", licensePaths=" + this.getLicensePaths() + "]";
    }

    private LicenseException handleErrorStatus(String errorMsg, LmxStatus status) {
        this.setLicenseErrorMessage(errorMsg);
        LoggingHelper.warn(errorMsg, new Object[0]);
        LicenseException licenseException = new LicenseException(errorMsg, status);
        this.setCurrentError(licenseException);
        return licenseException;
    }

    private LicenseException handleLmxException(String message, LmxException exception, Supplier<LicenseEvent> event) {
        LicenseException lmxException = this.handleLmxException(message, exception);
        this.service.postEvent(event.get());
        return lmxException;
    }

    private LicenseException handleLmxException(String message, LmxException lmxException) {
        this.setLicenseErrorMessage(lmxException.getErrorStrSimple());
        String fullErrorMessage = String.valueOf(message) + ": " + lmxException.getErrorStr();
        LicenseException licenseException = new LicenseException(fullErrorMessage, lmxException);
        LoggingHelper.error(fullErrorMessage, new Object[0]);
        this.setCurrentError(licenseException);
        return licenseException;
    }

    private <T> T reportLongDurationInDebugger(LmxRunnable<T> runnable, String topic) throws LmxException {
        long duration;
        T t;
        long startTime = LicenseService.DEBUG ? System.currentTimeMillis() : 0L;
        try {
            t = runnable.run();
        }
        catch (Throwable throwable) {
            long duration2;
            if (LicenseService.DEBUG && (duration2 = System.currentTimeMillis() - startTime) > 3000L) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Object data = null;
                    Object lastLicIndex22 = null;
                    try (PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8.name());){
                        new Exception(String.valueOf(topic) + " took " + duration2 + "ms").printStackTrace(ps);
                    }
                    catch (Throwable lastLicIndex22) {
                        if (data == null) {
                            data = lastLicIndex22;
                        } else if (data != lastLicIndex22) {
                            ((Throwable)data).addSuppressed(lastLicIndex22);
                        }
                        throw data;
                    }
                    data = baos.toString(StandardCharsets.UTF_8.name());
                    int lastLicIndex = ((String)data).lastIndexOf("\tat com.yakindu.licmgmt.");
                    int callerLineIndex = ((String)data).indexOf("\tat ", lastLicIndex + 4);
                    int callerLineIndex2 = ((String)data).indexOf("\tat ", callerLineIndex + 4);
                    if (callerLineIndex2 > 0) {
                        System.err.println(((String)data).substring(0, callerLineIndex2));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            throw throwable;
        }
        if (LicenseService.DEBUG && (duration = System.currentTimeMillis() - startTime) > 3000L) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Throwable throwable = null;
                Object var11_15 = null;
                try (PrintStream ps = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8.name());){
                    new Exception(String.valueOf(topic) + " took " + duration + "ms").printStackTrace(ps);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                String data = baos.toString(StandardCharsets.UTF_8.name());
                int lastLicIndex22 = data.lastIndexOf("\tat com.yakindu.licmgmt.");
                int callerLineIndex = data.indexOf("\tat ", lastLicIndex22 + 4);
                int callerLineIndex2 = data.indexOf("\tat ", callerLineIndex + 4);
                if (callerLineIndex2 > 0) {
                    System.err.println(data.substring(0, callerLineIndex2));
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return t;
    }

    protected final class ExpiredTrialException
    extends Exception {
        protected ExpiredTrialException() {
        }
    }

    private static interface LmxRunnable<T> {
        public T run() throws LmxException;
    }
}

