/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.ui;

import com.yakindu.base.expressions.expressions.impl.LiteralImpl;
import com.yakindu.base.types.Declaration;
import com.yakindu.sct.model.sgraph.Pseudostate;
import com.yakindu.sct.model.sgraph.Region;
import com.yakindu.sct.model.sgraph.State;
import com.yakindu.sct.model.sgraph.Transition;
import com.yakindu.sct.search.core.IModelSearchEngine;
import com.yakindu.sct.search.core.filter.ClassesFilter;
import com.yakindu.sct.search.core.filter.FeatureFilter;
import com.yakindu.sct.search.core.filter.FeatureRegexFilter;
import com.yakindu.sct.search.core.filter.ModelFilter;
import com.yakindu.sct.search.core.filter.sct.CrossReferenceTextFilter;
import com.yakindu.sct.search.ui.SearchSelection;
import com.yakindu.sct.search.ui.UIModelSearchQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class UIModelSearchPage
extends DialogPage
implements ISearchPage {
    private final String SEARCHBAR_TEXT = "(* = any string, ? = any character, \\ = escape for literals: * ? \\)";
    private Combo fPattern;
    private Button fIsRegExCheckbox;
    private CLabel fSearchStringLabel;
    private ContentAssistCommandAdapter fPatterFieldContentAssist;
    private ISearchPageContainer searchContainer;
    private Button fRegionStatesBtn;
    private Button fDeclarationsBtn;
    private Button fPropertiesBtn;
    List<Resource> resources = new ArrayList<Resource>();
    private Button fWorkspaceBtn;
    private Button fResourceBtn;
    private Button fIsCaseSensitiveCheckbox;

    private void addScopeControls(Composite optionComposite) {
        Composite scopeComposite = new Composite(optionComposite, 0);
        scopeComposite.setFont(optionComposite.getFont());
        GridLayout scopeLayout = new GridLayout(2, false);
        scopeComposite.setLayout((Layout)scopeLayout);
        Group scopeGroup = new Group(scopeComposite, 16);
        scopeGroup.setLayout((Layout)new GridLayout(3, false));
        scopeGroup.setText("Scope");
        scopeGroup.setFont(scopeComposite.getFont());
        scopeGroup.setEnabled(true);
        this.fWorkspaceBtn = new Button((Composite)scopeGroup, 16);
        this.fWorkspaceBtn.setText("Workspace");
        this.fWorkspaceBtn.setVisible(true);
        this.fWorkspaceBtn.setEnabled(true);
        this.fWorkspaceBtn.setSelection(false);
        this.fResourceBtn = new Button((Composite)scopeGroup, 16);
        this.fResourceBtn.setText("Selected resources");
        this.fResourceBtn.setVisible(true);
        this.fResourceBtn.setEnabled(true);
        this.fResourceBtn.setSelection(true);
    }

    private void addSearchBarControls(final Composite group) {
        Label label = new Label(group, 16384);
        label.setText("Search string");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.fPattern = new Combo(group, 2052);
        this.fPattern.setFont(group.getFont());
        GridData data = new GridData(4, 4, true, false, 2, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UIModelSearchPage.this.fIsRegExCheckbox.getSelection()) {
                    try {
                        Pattern.compile(UIModelSearchPage.this.fPattern.getText());
                        UIModelSearchPage.this.fSearchStringLabel.setText("");
                    }
                    catch (PatternSyntaxException exception) {
                        int indexOfNewline = exception.getMessage().indexOf(10);
                        if (indexOfNewline == -1) {
                            UIModelSearchPage.this.fSearchStringLabel.setText(exception.getMessage());
                        } else {
                            UIModelSearchPage.this.fSearchStringLabel.setText(exception.getMessage().substring(0, indexOfNewline));
                        }
                        UIModelSearchPage.this.fSearchStringLabel.setForeground(new Color(null, 255, 0, 0));
                        return;
                    }
                } else {
                    UIModelSearchPage.this.fSearchStringLabel.setText("(* = any string, ? = any character, \\ = escape for literals: * ? \\)");
                    UIModelSearchPage.this.fSearchStringLabel.setForeground(group.getForeground());
                }
            }
        });
        ComboContentAdapter contentAdapter = new ComboContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.fPatterFieldContentAssist = new ContentAssistCommandAdapter((Control)this.fPattern, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        this.fPatterFieldContentAssist.setEnabled(false);
        this.fSearchStringLabel = new CLabel(group, 16384);
        this.fSearchStringLabel.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.fSearchStringLabel.setFont(group.getFont());
        this.fSearchStringLabel.setAlignment(16384);
        this.fSearchStringLabel.setText("(* = any string, ? = any character, \\ = escape for literals: * ? \\)");
        this.fIsRegExCheckbox = new Button(group, 32);
        this.fIsRegExCheckbox.setText("Regular expression");
        this.fIsRegExCheckbox.setSelection(false);
        this.fIsRegExCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIModelSearchPage.this.fPatterFieldContentAssist.setEnabled(UIModelSearchPage.this.fIsRegExCheckbox.getSelection());
                if (UIModelSearchPage.this.fIsRegExCheckbox.getSelection()) {
                    try {
                        Pattern.compile(UIModelSearchPage.this.fPattern.getText());
                        UIModelSearchPage.this.fSearchStringLabel.setText("");
                    }
                    catch (PatternSyntaxException exception) {
                        int indexOfNewline = exception.getMessage().indexOf(10);
                        if (indexOfNewline == -1) {
                            UIModelSearchPage.this.fSearchStringLabel.setText(exception.getMessage());
                        } else {
                            UIModelSearchPage.this.fSearchStringLabel.setText(exception.getMessage().substring(0, indexOfNewline));
                        }
                        UIModelSearchPage.this.fSearchStringLabel.setForeground(new Color(null, 255, 0, 0));
                        return;
                    }
                } else {
                    UIModelSearchPage.this.fSearchStringLabel.setText("(* = any string, ? = any character, \\ = escape for literals: * ? \\)");
                    UIModelSearchPage.this.fSearchStringLabel.setForeground(group.getForeground());
                }
            }
        });
        this.fIsRegExCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsRegExCheckbox.setFont(group.getFont());
        this.fIsCaseSensitiveCheckbox = new Button(group, 32);
        this.fIsCaseSensitiveCheckbox.setText("Case sensitive");
        this.fIsCaseSensitiveCheckbox.setSelection(false);
        this.fIsCaseSensitiveCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsCaseSensitiveCheckbox.setFont(group.getFont());
    }

    private void addSearchForControls(Composite optionComposite) {
        Composite filterComposite = new Composite(optionComposite, 0);
        filterComposite.setFont(optionComposite.getFont());
        GridLayout filterLayout = new GridLayout(3, false);
        filterComposite.setLayout((Layout)filterLayout);
        Group seachforGroup = new Group(filterComposite, 16);
        seachforGroup.setLayout((Layout)new GridLayout(3, false));
        seachforGroup.setText("Search For ");
        seachforGroup.setFont(filterComposite.getFont());
        seachforGroup.setEnabled(true);
        this.fRegionStatesBtn = new Button((Composite)seachforGroup, 32);
        this.fRegionStatesBtn.setText("States/Regions");
        this.fRegionStatesBtn.setVisible(true);
        this.fRegionStatesBtn.setEnabled(true);
        this.fRegionStatesBtn.setSelection(true);
        this.fDeclarationsBtn = new Button((Composite)seachforGroup, 32);
        this.fDeclarationsBtn.setText("Declarations");
        this.fDeclarationsBtn.setVisible(true);
        this.fDeclarationsBtn.setEnabled(true);
        this.fDeclarationsBtn.setSelection(true);
        this.fPropertiesBtn = new Button((Composite)seachforGroup, 32);
        this.fPropertiesBtn.setText("Properties");
        this.fPropertiesBtn.setVisible(true);
        this.fPropertiesBtn.setEnabled(true);
        this.fPropertiesBtn.setSelection(true);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite searchBar = new Composite(parent, 4);
        searchBar.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        searchBar.setLayout((Layout)layout);
        searchBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.addSearchBarControls(searchBar);
        Composite optionComposite = new Composite(parent, 4);
        optionComposite.setFont(parent.getFont());
        optionComposite.setLayout((Layout)new GridLayout(2, false));
        optionComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.addSearchForControls(optionComposite);
        this.addScopeControls(optionComposite);
        this.setControl((Control)parent);
    }

    public String getLabel() {
        return "Model Search Page";
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    public boolean performAction() {
        int selectionType = -1;
        if (this.fWorkspaceBtn.getSelection()) {
            selectionType = 0;
        } else if (this.fResourceBtn.getSelection()) {
            selectionType = 1;
        }
        SearchSelection selection = new SearchSelection(selectionType, this.searchContainer.getSelection());
        UIModelSearchQuery searchQuery = new UIModelSearchQuery(selection);
        searchQuery.setLabel("\"" + this.fPattern.getText() + "\"");
        this.prepareFilter(searchQuery);
        NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
        return true;
    }

    public void prepareFilter(IModelSearchEngine.ModelSearchQuery searchQuery) {
        ClassesFilter preCRClassesFilter = new ClassesFilter();
        ClassesFilter featureClassesFilter = new ClassesFilter();
        FeatureFilter featureFilter = new FeatureFilter();
        if (this.fRegionStatesBtn.getSelection()) {
            preCRClassesFilter.addClass(State.class);
            preCRClassesFilter.addClass(Pseudostate.class);
            preCRClassesFilter.addClass(Region.class);
            featureClassesFilter.addClass(State.class);
            featureClassesFilter.addClass(Pseudostate.class);
            featureClassesFilter.addClass(Region.class);
            if (this.fIsRegExCheckbox.getSelection()) {
                featureFilter.add("name");
                featureFilter.add("documentation");
                featureFilter.add("specification");
            }
        }
        if (this.fDeclarationsBtn.getSelection()) {
            preCRClassesFilter.addClass(LiteralImpl.class);
            preCRClassesFilter.addClass(Transition.class);
            preCRClassesFilter.addClass(Declaration.class);
            featureClassesFilter.addClass(LiteralImpl.class);
            featureClassesFilter.addClass(Transition.class);
            featureClassesFilter.addClass(Declaration.class);
            if (this.fIsRegExCheckbox.getSelection()) {
                featureFilter.add("name");
                featureFilter.add("documentation");
                featureFilter.add("specification");
            }
        }
        if (this.fPropertiesBtn.getSelection()) {
            featureClassesFilter.addClass(Transition.class);
            featureClassesFilter.addClass(State.class);
            featureFilter.add("documentation");
            featureClassesFilter.addClass(LiteralImpl.class);
            featureFilter.add("value");
            featureClassesFilter.addClass(Shape.class);
            featureFilter.add("description");
        }
        CrossReferenceTextFilter crossReferenceFilter = new CrossReferenceTextFilter(this.getPattern(), searchQuery.getCandidates(), false, this.fIsRegExCheckbox.getSelection());
        ClassesFilter postCRClassesFilter = new ClassesFilter(preCRClassesFilter.getClasses());
        FeatureRegexFilter regexFilter = new FeatureRegexFilter(this.getPattern(), false, this.fIsRegExCheckbox.getSelection());
        featureFilter.addChild((ModelFilter)regexFilter);
        featureClassesFilter.addChild((ModelFilter)featureFilter);
        preCRClassesFilter.addChild((ModelFilter)crossReferenceFilter);
        crossReferenceFilter.addChild((ModelFilter)postCRClassesFilter);
        Set allClasses = preCRClassesFilter.getClasses();
        allClasses.addAll(featureClassesFilter.getClasses());
        ClassesFilter root = new ClassesFilter(allClasses);
        root.addChild((ModelFilter)featureClassesFilter);
        root.addChild((ModelFilter)preCRClassesFilter);
        searchQuery.setFilterFunction((ModelFilter)root);
    }

    public void setContainer(ISearchPageContainer container) {
        this.searchContainer = container;
    }
}

