/*
 * Decompiled with CFR 0.152.
 */
package com.yakindu.sct.search.ui.provider;

import com.yakindu.base.base.NamedElement;
import com.yakindu.sct.model.stext.stext.InterfaceScope;
import com.yakindu.sct.search.core.Marker;
import com.yakindu.sct.search.core.ModelSearchResultEntry;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class ResultColumnLabelProvider
extends DelegatingStyledCellLabelProvider {
    public ResultColumnLabelProvider(TreeViewer viewer) {
        super(new DelegatingStyledCellLabelProvider.IStyledLabelProvider(viewer){
            StyledString.Styler resultStyler;
            private AdapterFactoryLabelProvider adapterFactoryLabelProvider;
            {
                this.resultStyler = new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        Font boldFont;
                        FontDescriptor boldDescriptor = FontDescriptor.createFrom((FontData[])treeViewer.getTree().getFont().getFontData()).setStyle(1);
                        textStyle.font = boldFont = boldDescriptor.createFont((Device)Display.getCurrent());
                        textStyle.underline = true;
                        textStyle.underlineColor = new Color(null, 51, 153, 51);
                        textStyle.underlineStyle = 1;
                    }
                };
                this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
            }

            public void addListener(ILabelProviderListener listener) {
                this.adapterFactoryLabelProvider.addListener(listener);
            }

            public void dispose() {
                this.adapterFactoryLabelProvider.dispose();
            }

            private StyledString getHighlightedText(ModelSearchResultEntry entry, String attributeText, int startIndex, int endIndex) {
                StyledString string = new StyledString();
                int i = startIndex;
                while (i < endIndex) {
                    List marker = entry.getMarker();
                    boolean skipCharAfterLoop = false;
                    for (Marker marker2 : marker) {
                        if (i < marker2.getStartMarker() || i >= marker2.getEndMarker()) continue;
                        skipCharAfterLoop = true;
                        int j = i;
                        while (j < marker2.getEndMarker()) {
                            string.append(attributeText.charAt(j), this.resultStyler);
                            ++j;
                        }
                        i = marker2.getEndMarker() - 1;
                    }
                    if (!skipCharAfterLoop) {
                        string.append(attributeText.charAt(i));
                    }
                    ++i;
                }
                return string;
            }

            public Image getImage(Object element) {
                return null;
            }

            public StyledString getStyledText(Object element) {
                StyledString secondPart = new StyledString();
                if (element instanceof ModelSearchResultEntry) {
                    ModelSearchResultEntry entry = (ModelSearchResultEntry)element;
                    if (entry.getResult() instanceof EAttribute) {
                        Object attributeValue = entry.getParent().eGet((EStructuralFeature)((EAttribute)entry.getResult()));
                        if (attributeValue instanceof String) {
                            String attributeText = (String)attributeValue;
                            int startMarker = ((Marker)entry.getMarker().get(0)).getStartMarker();
                            int endMarker = ((Marker)entry.getMarker().get(entry.getMarker().size() - 1)).getEndMarker();
                            int startLine = attributeText.lastIndexOf(10, startMarker - 1);
                            startLine = startLine == -1 ? 0 : ++startLine;
                            int endLine = attributeText.indexOf(10, endMarker);
                            endLine = endLine == -1 ? attributeText.length() : ++endLine;
                            if (endLine - startLine < 120) {
                                secondPart.append(this.getHighlightedText(entry, attributeText, startLine, endLine));
                            } else if (endMarker - startLine < 120) {
                                secondPart.append(this.getHighlightedText(entry, attributeText, startLine, endMarker));
                                if (endLine != endMarker) {
                                    secondPart.append("[...]", StyledString.QUALIFIER_STYLER);
                                }
                            } else if (endLine - startMarker < 120) {
                                if (startLine != startMarker) {
                                    secondPart.append("[...]", StyledString.QUALIFIER_STYLER);
                                }
                                secondPart.append(this.getHighlightedText(entry, attributeText, startMarker, endLine));
                            } else {
                                int restSize = Math.max(0, (120 - (endMarker - startMarker)) / 2);
                                if (startLine != startMarker || startLine < startMarker - restSize) {
                                    secondPart.append("[...]", StyledString.QUALIFIER_STYLER);
                                }
                                int startIndex = restSize > 0 ? Math.max(0, startMarker - restSize) : startMarker;
                                secondPart.append(attributeText.substring(startIndex, startMarker));
                                secondPart.append(this.getHighlightedText(entry, attributeText, startMarker, endMarker));
                                if (startLine - (startMarker - restSize) < 0) {
                                    restSize += Math.abs(startLine - (startMarker - restSize));
                                }
                                int endIndex = restSize > 0 ? Math.min(endLine, endMarker + restSize) : endMarker;
                                secondPart.append(attributeText.substring(endMarker, endIndex));
                                if (endLine != endMarker || endLine > endMarker + restSize) {
                                    secondPart.append("[...]", StyledString.QUALIFIER_STYLER);
                                }
                            }
                        }
                    } else if (entry.getResult() instanceof NamedElement) {
                        String name;
                        if (entry.getResult().eContainer() instanceof InterfaceScope && (name = ((InterfaceScope)entry.getResult().eContainer()).getName()) != null) {
                            secondPart.append(name, this.resultStyler);
                            secondPart.append(".", this.resultStyler);
                        }
                        if ((name = ((NamedElement)entry.getResult()).getName()) == null) {
                            name = "";
                        }
                        secondPart.append(name, this.resultStyler);
                    }
                }
                return secondPart;
            }

            public boolean isLabelProperty(Object element, String property) {
                return this.adapterFactoryLabelProvider.isLabelProperty(element, property);
            }

            public void removeListener(ILabelProviderListener listener) {
                this.adapterFactoryLabelProvider.removeListener(listener);
            }
        });
    }
}

