/**
 * Copyright (c) 2019 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * 
 */
package com.yakindu.sctunit.generator.python.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.TimeEventSpec
import com.yakindu.sct.generator.core.library.ICoreLibraryHelper
import com.yakindu.sct.generator.python.naming.Naming
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sctunit.generator.base.extensions.BaseNamingExtensions
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions
import com.yakindu.sctunit.generator.python.PythonSCTUnitFileSystemAccessFactory
import com.yakindu.sctunit.generator.python.features.PythonSCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite
import com.yakindu.sctunit.sCTUnit.TestPackage
import org.eclipse.emf.common.util.URI
import org.eclipse.xtext.generator.IFileSystemAccess

class JUnitTest {

	@Inject protected NamingExtensions naming
	@Inject extension BaseNamingExtensions
	@Inject extension BaseNavigationExtensions
	@Inject extension PythonSCTUnitGenmodelEntries
	@Inject extension StatechartAnnotations
	@Inject protected GeneratorEntry entry
	@Inject protected extension Naming

	@Inject
	protected ICoreLibraryHelper helper

	def generateJUnitTest(TestPackage it, IFileSystemAccess fsa, String targetProjectName) {

		var targetProjectString = helper.getTargetProjectValue(entry).stringValue

		var content = SCTUnitElement.generateTest(targetProjectString)
		fsa.generateFile(SCTUnitElement.testClassName.java, PythonSCTUnitFileSystemAccessFactory.PYTHON_JUNIT_OUTPUT, content)
	}

	def dispatch generateTest(SCTUnitClass it, String targetProjectString) {
		'''
			«entry.licenseText»
			package «targetProjectString»«IF !namespace(testPackage).toString.nullOrEmpty».«ENDIF»«it.namespace»;
			
			import org.junit.Before;
			import org.junit.runner.RunWith;
			
			@PythonTest(
				statechartBundle = "«statechart.eResource.URI.segment(1)»",
				sourceFile = "«entry.targetFolderString»/«testClassName.toLowerCase»/«py(naming.testClassName(it))»",
				program = "«entry.targetFolderString»/«testClassName.toLowerCase»/«statechart.className»",
				model = "«statechart.eResource.URI.modelFromUri»",
				additionalFilesToCopy = {
					"«targetFolder»/«testClassName.toLowerCase»/__init__.py"«IF statechart.isCycleBased || statechart.timed»,
					"«targetFolder»/«testClassName.toLowerCase»/vtimer/__init__.py",
					"«targetFolder»/«testClassName.toLowerCase»/vtimer/interface_timer.py",
					"«targetFolder»/«testClassName.toLowerCase»/vtimer/virtual_timer.py"«ENDIF»
				}
			)
			@RunWith(PythonTestRunner.class)
			public class «testClassName» {
			
				protected final PythonTestHelper helper = new PythonTestHelper(this);
			
				@Before
				public void setUp() {
					helper.generate();
				}
			}
		'''
	} 
	
	def protected targetFolder() {
		'''«IF entry.libraryTargetFeature === null»«entry.targetFolderString»«ELSE»«entry.libraryTargetFolderString»«ENDIF»'''
	}

	/**
	 * Derives and returns the path implied by the namespace as string. 
	 * The hierarchical namespace will be mapped to a path by substituting the namespace
	 * separators by path separators with an additional trailing path separator if the namespace exists. 
	 */
	def String asPath(String namespace) {
		if (namespace !== null && ! namespace.empty) {
			return namespace.replace('.', '/') + '/'
		}
		return ''
	}

	def dispatch generateTest(SCTUnitSuite it, String targetProjectString) {
		'''
			«entry.licenseText»
			package «targetProjectString»«IF !namespace(testPackage).toString.nullOrEmpty».«ENDIF»«it.namespace»;
			import org.junit.runner.RunWith;
			import org.junit.runners.Suite;
			import org.junit.runners.Suite.SuiteClasses;
			
			@RunWith(Suite.class)
			@SuiteClasses({
				«FOR group : SCTUnitClasses SEPARATOR ','»
					«group.testClassName».class
				«ENDFOR»
			})
			public class «className» {
			}
		'''
	}
	
	def protected isTimed(SCTUnitClass it) {
		statechart.eAllContents.findFirst[it instanceof TimeEventSpec] !== null
	}
	
	def protected getModelFromUri(URI uri){
		var model = uri.segment(2)
		for(var i=3; i<uri.segmentsList.size; i++){
			model = model + "/" + uri.segment(i)
		}
		return model
	}
	
	def protected isTimed(Statechart it) {
		it.eAllContents.filter(typeof(TimeEventSpec)).size > 0
	}
}
