/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sctunit.generator.python.library.impl

import static com.yakindu.base.types.typesystem.ITypeSystem.*
import com.yakindu.sct.generator.core.library.impl.CoreFeatureTypeLibraryProvider

class PythonSGenFeatureTypeLibraryProvider extends CoreFeatureTypeLibraryProvider {
	def naming() {
		createFeatureType => [
			name = "Naming"
			optional = true
			parameters += createFeatureParameter => [
				name = "basePackage"
				parameterType = getType(STRING)
			]
		]
	}

	def statechartNaming() {
		createFeatureType => [
			name = "StatechartNaming"
			optional = true
			parameters += createFeatureParameter => [
				name = "libraryPackage"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "basePackage"
				optional = true
				parameterType = getType(STRING)
			]
			parameters += createFeatureParameter => [
				name = "libraryTargetFolder"
				parameterType = getType(STRING)
			]
		]
	}

	def junitWrapper() {
		createFeatureType => [
			name = "JUnitWrapper"
			optional = true
			parameters += createFeatureParameter => [
				name = "WrapToJUnit"
				parameterType = getType(BOOLEAN)
			]
		]
	}

	override provide() {
		create([super.provide]) => [
			name = "SCTUnit Python Generator"
			types += naming()
			types += statechartNaming()
			types += junitWrapper()
		]
	}
}
