/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.cpp.extensions

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Package
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sctunit.generator.c.extensions.CMockingExtensions
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.MockingStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.VerifyCalledStatement
import java.util.Set
import org.eclipse.emf.ecore.EObject
import com.itemis.create.base.generator.core.GeneratorAssignment
import org.eclipse.xtext.xbase.lib.Functions.Function0

/**
 * 
 * @author Jonathan Thoene - Initial contribution and API
 * 
 */
class CppMockingExtensions extends CMockingExtensions{
	@Inject extension SExecExtensions
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension SCTUnitCppNaming
	@Inject extension CppNaming
	@Inject extension GeneratorAssignment

	
	def generateMockClasses(SCTUnitClass it){
		'''
			«FOR sc: statechart.scopes.filter[hasOperations]»
				class «sc.mockClassName» : public «statechart.typeName»::«sc.scopedAccess»«sc.interfaceOCBName» {
					public:
					«testClassName»* owner;
					«sc.mockClassName»(«testClassName»* owner) : owner(owner) {}
					«generateRequiredOperations(sc)»
				};
			«ENDFOR»
		'''
	}
	
	def setupInterfaceCallbacks(SCTUnitClass clazz) {
		val allScopes = clazz.statechart.scopes.filter(InterfaceScope) + clazz.statechart.scopes.filter(InternalScope)
		'''
		«FOR sc:allScopes»
			«IF sc !== null && !sc.members.filter(OperationDefinition).nullOrEmpty»
				«ref»«IF sc.isNamedScope»«sc.asGetter»()«ifaceAcces»«ENDIF»set«IF sc instanceof InternalScope»Internal«ENDIF»OperationCallback(«sc.mockObjectName»);
			«ENDIF»
		«ENDFOR»
		'''
	}
	
	def defineInterfaceMockObjects(SCTUnitClass clazz){
		val allScopes = clazz.statechart.scopes.filter(InterfaceScope) + clazz.statechart.scopes.filter(InternalScope)
		'''
		«FOR sc: allScopes»
			«IF sc !== null && !sc.members.filter(OperationDefinition).nullOrEmpty»
				«sc.mockClassName»* «sc.mockObjectName»;
			«ENDIF»	
		«ENDFOR»
		'''
	}
		
	def setupInterfaceMockInstances(SCTUnitClass clazz){
		val allScopes = clazz.statechart.scopes.filter(InterfaceScope) + clazz.statechart.scopes.filter(InternalScope)
		'''
		«FOR sc: allScopes»
			«IF sc !== null && !sc.members.filter(OperationDefinition).nullOrEmpty»
				«sc.mockObjectName» = new «sc.mockClassName»(this);
			«ENDIF»	
		«ENDFOR»
		'''
	}
	
	def tearDownInterfaceMockInstances(SCTUnitClass clazz){
		val allScopes = clazz.statechart.scopes.filter(InterfaceScope) + clazz.statechart.scopes.filter(InternalScope)
		'''
		«FOR sc: allScopes»
			«IF sc !== null && !sc.members.filter(OperationDefinition).nullOrEmpty»
				delete «sc.mockObjectName»;
				«sc.mockObjectName» = 0;
			«ENDIF»	
		«ENDFOR»
		'''
	}
		
	
	def dispatch generateMockingStatement(VerifyCalledStatement it){
		if(!negated) {
			generatePositiveVerify
		} else {
			generateNegativeVerify
		}
	}
	
	def dispatch generateMockingStatement(MockReturnStatement it){
		'''
			«generateMock»
		'''
	}
	
	def generateReturnClasses(SCTUnitClass it){
		'''
		«FOR op: statechart.allOperations»
		«IF !getCustomAnswerStatements(op).empty»
			«op.generateReturnClass(getCustomAnswerStatements(op))»
		«ENDIF»
		«ENDFOR»
		'''
	}
	
	def generateReturnClass(Operation it, Set<MockReturnStatement> stms){
		'''
			class «returnClassName»{
				public:
					«FOR stm : stms»
						«typeSpecifier.targetLanguageName» static «stm.returnMethodName(stms)»(«FOR pa:parameters SEPARATOR ', '»«pa.typeSpecifier.targetLanguageName» «pa.name»«ENDFOR»){
							return «stm.value.code»;
						}
					«ENDFOR»
			};
		'''
	}
	
	def protected generateRequiredOperations(SCTUnitClass it, Scope sc) {
		val operations = sc.declarations.filter(Operation).toList
		operations.forEach[generateOwnerAccessWith['''owner->''']]
		'''
			«FOR op : sc.declarations.filter(Operation)»
				«generateOperationSignature(op)»
					«IF !isOperationForStatement(op, typeof(VerifyCalledStatement)) && !isOperationForStatement(op, typeof(MockReturnStatement))»
						«FOR param : op.parameters»
							SC_UNUSED(«param.name»);
						«ENDFOR»
					«ENDIF»
					«IF isOperationForStatement(op, typeof(VerifyCalledStatement))»
						«op.generateVerifyStatement»
					«ENDIF»
					«IF isOperationForStatement(op, typeof(MockReturnStatement))»
						«op.generateMockReturnStatement»
					«ELSE»
						«defaultReturn(op.getType)»
					«ENDIF»
				}
			«ENDFOR»
		'''
	}
	
	def generateRequiredHeaderOperations(SCTUnitClass it) {
		val mockedOperations = mockedExternalOperations
		val testClass = it
		mockedOperations.forEach[ generateOwnerAccessWith['''«testClass.testClassName»::current->''']]
		'''
			«FOR op : mockedOperations»
				«op.generateOperationSignature»
					«IF isOperationForStatement(op, typeof(VerifyCalledStatement))»
						«op.generateVerifyStatement»
					«ENDIF»
					«IF isOperationForStatement(op, typeof(MockReturnStatement))»
						«op.generateMockReturnStatement»
					«ELSE»
						«defaultReturn(op.getType)»
					«ENDIF»
				}
			«ENDFOR»
		'''
	}

	def mockedExternalOperations(SCTUnitClass it) {
		val statechartOperations = statechart
										.scopes
										.map[s|s.declarations]
										.flatten
										.filter(Operation)
										.toList
		getAllOperations(allMockStatementsInClass)
			.filter[op|!statechartOperations.contains(op)]
			.toList
	}
	
	
	static class OwnerAccessAdapter extends GeneratorAssignment.Adapter {
		new(Function0<CharSequence> g) {
			super(g)
		}
	}
	def <T extends EObject> T generateOwnerAccessWith(T it, Function0<CharSequence> g) {
		return assignGenerator(new OwnerAccessAdapter(g))
	}	
	
	def CharSequence ownerAccessCode(EObject it) {
		it.assignedGenerator(OwnerAccessAdapter)?.apply
	}
	
	
	override  CharSequence generateStatechartOperationSignature(SCTUnitClass it,Operation op) {
		'''
			«op.typeSpecifier.targetLanguageName» «op.name»(«FOR param : op.parameters SEPARATOR ', '»«param.typeSpecifier.targetLanguageName» «param.name»«ENDFOR») {
		'''
	}
	
	protected override CharSequence generateOperationSignature(Operation it) {
		'''
			«it.typeSpecifier.targetLanguageName» «operationName»(«FOR param : parameters SEPARATOR ', '»«param.typeSpecifier.targetLanguageName» «param.name»«ENDFOR») {
		'''
	}
	
	def private String operationName(Declaration it) {
		val container = eContainer
		if (container.isClass || container.isNamespace) {
			return '''«(container as Declaration).operationName»::«name»'''
		}
		return name
	}
	
	def private isClass(EObject it) {
		it instanceof ComplexType
	}
	
	def private isNamespace(EObject it) {
		it instanceof Package && eContainer !== null
	}

	def protected getCustomAnswerStatements(SCTUnitClass it, Operation op){
		SCTUnitOperations.map[tc|tc.body.code].flatten.filter(MockReturnStatement).filter[ms|ms.reference.operation == op].filter[ms|ms.value.customAnswer].toSet
	}
	
	def getOperationParams(MockingStatement it){
		reference.operation.parameters
	}
	
	override initializeOperationMock(Operation it, boolean initialize) {
	'''
		«operationMockObjectName» = new «operationMockClassName»(this);
		«IF initialize»
			«operationMockObjectName»->initializeBehavior();
		«ENDIF»
	'''
	}
	
	override protected generateVerifyStatement(Operation it) {		
		'''
			«it.ownerAccessCode»«operationMockObjectName»->«name»(«FOR param : parameters SEPARATOR ', '»«param.name»«ENDFOR»);
		'''
	}
	

	override protected generateMockReturnStatement(Operation it) {
		'''
			return («it.ownerAccessCode»«operationMockObjectName»->*(«it.ownerAccessCode»«operationMockObjectName»->getBehavior(«FOR param : parameters SEPARATOR ', '»«param.name»«ENDFOR»)))();
		'''
	}

	
}
