/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.genmodel

import com.google.inject.Binder
import com.yakindu.base.expressions.linking.LinkingDiagnosticMessageProvider
import com.yakindu.base.expressions.parser.SyntaxErrorMessageProvider
import com.yakindu.base.expressions.terminals.ExpressionsValueConverterService
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.base.types.typesystem.GenericTypeSystem
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.genmodel.formatting.SGenFormatter
import com.yakindu.sct.generator.genmodel.naming.GenModelQualifiedNameProvider
import com.yakindu.sct.generator.genmodel.scoping.SGenGlobalScopeProvider
import com.yakindu.sct.generator.genmodel.serializer.SGenCrossReferenceSerializer
import com.yakindu.sct.generator.genmodel.typesystem.SGenTypeInferrer
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider
import org.eclipse.xtext.naming.IQualifiedNameProvider
import org.eclipse.xtext.parser.antlr.ISyntaxErrorMessageProvider
import org.eclipse.xtext.scoping.IGlobalScopeProvider
import org.eclipse.xtext.serializer.tokens.ICrossReferenceSerializer

class SGenRuntimeModule extends AbstractSGenRuntimeModule {

	def Class<? extends ILinkingDiagnosticMessageProvider> bindILinkingDiagnosticMessageProvider() {
		LinkingDiagnosticMessageProvider
	}

	def configureITypeSystem(Binder binder) {
		binder.bind(ITypeSystem).toInstance(GenericTypeSystem.getInstance())
	}

	def Class<? extends ISyntaxErrorMessageProvider> bindISyntaxErrorMessageProvider() {
		SyntaxErrorMessageProvider
	}

	def Class<? extends ITypeSystemInferrer> bindITypeSystemInferrer() {
		return SGenTypeInferrer
	}

	override Class<? extends IQualifiedNameProvider> bindIQualifiedNameProvider() {
		return GenModelQualifiedNameProvider
	}

	def Class<? extends ICrossReferenceSerializer> bindICrossReferenceSerializer() {
		return SGenCrossReferenceSerializer
	}

	override Class<? extends IGlobalScopeProvider> bindIGlobalScopeProvider() {
		return SGenGlobalScopeProvider
	}
	
	override bindIValueConverterService() {
		ExpressionsValueConverterService
	}
	
	override bindIFormatter() {
		SGenFormatter
	}
	
}
